/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application.capabilities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.common.Webhook;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Capability {
    protected Map<Webhook.Type, Webhook> webhooks;

    protected Capability() {
    }

    @JsonIgnore
    public abstract Type getType();

    @JsonProperty(value="webhooks")
    public Map<Webhook.Type, Webhook> getWebhooks() {
        return this.webhooks;
    }

    static abstract class Builder<C extends Capability, B extends Builder<C, B>> {
        Map<Webhook.Type, Webhook> webhooks;

        Builder() {
        }

        B addWebhook(Webhook.Type type, Webhook webhook) {
            if (this.webhooks == null) {
                this.webhooks = new LinkedHashMap<Webhook.Type, Webhook>();
            }
            this.webhooks.put(type, webhook);
            return (B)this;
        }

        B removeWebhook(Webhook.Type type) {
            if (this.webhooks != null) {
                this.webhooks.remove((Object)type);
                if (this.webhooks.isEmpty()) {
                    this.webhooks = null;
                }
            }
            return (B)this;
        }

        public abstract C build();
    }

    public static enum Type {
        VOICE,
        RTC,
        MESSAGES,
        VBC;

    }
}

