/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application.capabilities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.application.capabilities.Capability;
import com.vonage.client.application.capabilities.Region;
import com.vonage.client.common.Webhook;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class Voice
extends Capability {
    private Region region;
    private Boolean signedCallbacks;
    private Integer conversationsTtl;

    private Voice() {
    }

    private Voice(Builder builder) {
        this.webhooks = builder.webhooks;
        this.region = builder.region;
        this.signedCallbacks = builder.signedCallbacks;
        this.conversationsTtl = builder.conversationsTtl;
        if (this.conversationsTtl != null && (this.conversationsTtl < 0 || this.conversationsTtl > 744)) {
            throw new IllegalArgumentException("Conversations TTL cannot be negative.");
        }
    }

    @JsonProperty(value="region")
    public Region getRegion() {
        return this.region;
    }

    @JsonProperty(value="signed_callbacks")
    public Boolean getSignedCallbacks() {
        return this.signedCallbacks;
    }

    @JsonProperty(value="conversations_ttl")
    public Integer getConversationsTtl() {
        return this.conversationsTtl;
    }

    @Override
    public Capability.Type getType() {
        return Capability.Type.VOICE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Capability.Builder<Voice, Builder> {
        private Region region;
        private Boolean signedCallbacks;
        private Integer conversationsTtl;

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder signedCallbacks(boolean signed) {
            this.signedCallbacks = signed;
            return this;
        }

        public Builder conversationsTtl(int ttl) {
            this.conversationsTtl = ttl;
            return this;
        }

        @Override
        public Builder addWebhook(Webhook.Type type, Webhook webhook) {
            return (Builder)super.addWebhook(type, webhook);
        }

        @Override
        public Builder removeWebhook(Webhook.Type type) {
            return (Builder)super.removeWebhook(type);
        }

        @Override
        public Voice build() {
            return new Voice(this);
        }
    }
}

