/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.AuthMethod;
import com.vonage.jwt.Jwt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.http.client.methods.RequestBuilder;

public class JWTAuthMethod
implements AuthMethod {
    private static final int SORT_KEY = 10;
    private final Jwt jwt;
    private final String applicationId;

    public JWTAuthMethod(String applicationId, byte[] privateKey) {
        this.applicationId = applicationId;
        this.jwt = Jwt.builder().applicationId(this.applicationId).privateKeyContents(new String(privateKey)).build();
    }

    public JWTAuthMethod(String applicationId, Path path) throws IOException {
        this(applicationId, Files.readAllBytes(path));
    }

    public String generateToken() {
        return this.jwt.generate();
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Jwt.Builder newJwt() {
        return Jwt.builder().applicationId(this.applicationId).privateKeyContents(this.jwt.getPrivateKeyContents());
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        return request.setHeader("Authorization", "Bearer " + this.generateToken());
    }

    @Override
    public int getSortKey() {
        return 10;
    }
}

