/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.hashutils.HashUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class RequestSigning {
    public static final int MAX_ALLOWABLE_TIME_DELTA = 300000;
    public static final String PARAM_SIGNATURE = "sig";
    public static final String PARAM_TIMESTAMP = "timestamp";
    public static final String APPLICATION_JSON = "application/json";
    private static final Log log = LogFactory.getLog(RequestSigning.class);

    public static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey) {
        RequestSigning.constructSignatureForRequestParameters(params, secretKey, Instant.now().getEpochSecond());
    }

    public static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey, HashUtil.HashType hashType) {
        RequestSigning.constructSignatureForRequestParameters(params, secretKey, Instant.now().getEpochSecond(), hashType);
    }

    protected static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey, long currentTimeSeconds) {
        RequestSigning.constructSignatureForRequestParameters(params, secretKey, currentTimeSeconds, HashUtil.HashType.MD5);
    }

    /*
     * WARNING - void declaration
     */
    protected static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey, long currentTimeSeconds, HashUtil.HashType hashType) {
        void var8_14;
        params.add((NameValuePair)new BasicNameValuePair(PARAM_TIMESTAMP, Long.toString(currentTimeSeconds)));
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        for (NameValuePair nameValuePair : params) {
            String string = nameValuePair.getName();
            String value = nameValuePair.getValue();
            if (string.equals(PARAM_SIGNATURE)) continue;
            if (value == null) {
                value = "";
            }
            if (value.trim().isEmpty()) continue;
            sortedParams.put(string, value);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sortedParams.entrySet()) {
            sb.append("&").append(RequestSigning.clean((String)entry.getKey())).append("=").append(RequestSigning.clean((String)entry.getValue()));
        }
        String string = sb.toString();
        String string2 = "no signature";
        try {
            String string3 = HashUtil.calculate(string, secretKey, "UTF-8", hashType);
        }
        catch (Exception e) {
            log.error((Object)"error...", (Throwable)e);
        }
        log.debug((Object)("SECURITY-KEY-GENERATION -- String [ " + string + " ] Signature [ " + (String)var8_14 + " ] "));
        params.add((NameValuePair)new BasicNameValuePair(PARAM_SIGNATURE, (String)var8_14));
    }

    public static boolean verifyRequestSignature(InputStream inputStream, String contentType, Map<String, String[]> parameterMap, String secretKey) {
        return RequestSigning.verifyRequestSignature(contentType, inputStream, parameterMap, secretKey, System.currentTimeMillis());
    }

    protected static boolean verifyRequestSignature(String contentType, InputStream inputStream, Map<String, String[]> parameterMap, String secretKey, long currentTimeMillis) {
        return RequestSigning.verifyRequestSignature(contentType, inputStream, parameterMap, secretKey, currentTimeMillis, HashUtil.HashType.MD5);
    }

    protected static boolean verifyRequestSignature(String contentType, InputStream inputStream, Map<String, String[]> parameterMap, String secretKey, long currentTimeMillis, HashUtil.HashType hashType) {
        String hashed;
        String suppliedSignature;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        if (APPLICATION_JSON.equals(contentType) && inputStream != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                Map map = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    log.info((Object)(name + " = " + value));
                    if (value == null || value.trim().isEmpty()) continue;
                    sortedParams.put(name, value);
                }
            }
            catch (IOException iOException) {
                throw new VonageUnexpectedException("Unexpected issue when parsing JSON", iOException);
            }
        } else {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String name = (String)entry.getKey();
                String value = ((String[])entry.getValue())[0];
                log.info((Object)(name + " = " + value));
                if (value == null || value.trim().isEmpty()) continue;
                sortedParams.put(name, value);
            }
        }
        if ((suppliedSignature = (String)sortedParams.get(PARAM_SIGNATURE)) == null) {
            return false;
        }
        String string = (String)sortedParams.get(PARAM_TIMESTAMP);
        long time = -1L;
        try {
            if (string != null) {
                time = Long.parseLong(string) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error parsing 'time' parameter [ " + string + " ]"), (Throwable)e);
            time = 0L;
        }
        long diff = currentTimeMillis - time;
        if (diff > 300000L || diff < -300000L) {
            log.warn((Object)("SECURITY-KEY-VERIFICATION -- BAD-TIMESTAMP ... Timestamp [ " + time + " ] delta [ " + diff + " ] max allowed delta [ " + -300000 + " ] "));
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry param : sortedParams.entrySet()) {
            if (((String)param.getKey()).equals(PARAM_SIGNATURE)) continue;
            String name = (String)param.getKey();
            String value = (String)param.getValue();
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        String str = sb.toString();
        try {
            hashed = HashUtil.calculate(str, secretKey, "UTF-8", hashType);
        }
        catch (Exception e) {
            log.error((Object)"error...", (Throwable)e);
            return false;
        }
        log.info((Object)("SECURITY-KEY-VERIFICATION -- String [ " + str + " ] Signature [ " + hashed + " ] SUPPLIED SIGNATURE [ " + suppliedSignature + " ] "));
        return MessageDigest.isEqual(hashed.toLowerCase().getBytes(StandardCharsets.UTF_8), suppliedSignature.toLowerCase().getBytes(StandardCharsets.UTF_8));
    }

    public static String clean(String str) {
        return str == null ? null : str.replaceAll("[=&]", "_");
    }
}

