/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.RequestSigning;
import com.vonage.client.auth.hashutils.HashUtil;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.RequestBuilder;

public class SignatureAuthMethod
implements AuthMethod {
    private static final int SORT_KEY = 20;
    private final String apiKey;
    private final String apiSecret;
    private final HashUtil.HashType hashType;

    public SignatureAuthMethod(String apiKey, String apiSecret) {
        this(apiKey, apiSecret, HashUtil.HashType.MD5);
    }

    public SignatureAuthMethod(String apiKey, String apiSecret, HashUtil.HashType hashType) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.hashType = hashType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public RequestBuilder apply(RequestBuilder request) {
        request.addParameter("api_key", this.apiKey);
        List params = request.getParameters();
        RequestSigning.constructSignatureForRequestParameters((List<NameValuePair>)params, this.apiSecret, this.hashType);
        int last = params.size() - 1;
        request.addParameters(new NameValuePair[]{(NameValuePair)params.get(last), (NameValuePair)params.get(last - 1)});
        return request;
    }

    @Override
    public int getSortKey() {
        return 20;
    }
}

