/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.auth.VonageAuthException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class VonageUnacceptableAuthException
extends VonageAuthException {
    private static final Map<Class<?>, String> AUTH_DESCRIPTION_MAP = new HashMap();
    private final Iterable<AuthMethod> availableAuths;
    private final Iterable<Class<? extends AuthMethod>> acceptableAuthClasses;

    public VonageUnacceptableAuthException(Collection<AuthMethod> availableAuths, Collection<Class<? extends AuthMethod>> acceptableAuthClasses) {
        this.availableAuths = new ArrayList<AuthMethod>(availableAuths);
        this.acceptableAuthClasses = new ArrayList<Class<? extends AuthMethod>>(acceptableAuthClasses);
    }

    @Override
    public String getMessage() {
        return this.generateErrorMessage();
    }

    private String generateErrorMessage() {
        TreeSet<String> availableTypes = new TreeSet<String>();
        for (AuthMethod auth : this.availableAuths) {
            availableTypes.add(AUTH_DESCRIPTION_MAP.getOrDefault(auth.getClass(), auth.getClass().getSimpleName()));
        }
        TreeSet<String> acceptableTypes = new TreeSet<String>();
        for (Class<? extends AuthMethod> klass : this.acceptableAuthClasses) {
            acceptableTypes.add(AUTH_DESCRIPTION_MAP.getOrDefault(klass, klass.getSimpleName()));
        }
        return String.format("No acceptable authentication type could be found. Acceptable types are: %s. Supplied types were: %s", String.join((CharSequence)", ", acceptableTypes), String.join((CharSequence)", ", availableTypes));
    }

    static {
        AUTH_DESCRIPTION_MAP.put(TokenAuthMethod.class, "API Key and Secret");
        AUTH_DESCRIPTION_MAP.put(SignatureAuthMethod.class, "API Key and Signature Secret");
        AUTH_DESCRIPTION_MAP.put(JWTAuthMethod.class, "Application ID and Private Key");
    }
}

