/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.common;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.regex.Pattern;

public class E164 {
    static final Pattern PATTERN = Pattern.compile("[1-9]\\d{6,14}");
    private final String number;

    public E164(String number) {
        Objects.requireNonNull(number, "Number cannot be null");
        String sanitized = number.replace(" ", "").replace("-", "");
        if (sanitized.startsWith("+")) {
            sanitized = sanitized.substring(1);
        }
        if (!PATTERN.matcher(sanitized).matches()) {
            throw new IllegalArgumentException("Malformed E.164 number: " + number);
        }
        this.number = sanitized;
    }

    @JsonValue
    public String toString() {
        return this.number;
    }
}

