/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.incoming;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.Jsonable;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.incoming.MessageType;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageEvent
implements Jsonable {
    private String msisdn;
    private String to;
    private String messageId;
    private String text;
    private String keyword;
    private String timestamp;
    private String nonce;
    private String data;
    private String udh;
    private MessageType type;
    private Date messageTimestamp;
    private Boolean concat;
    private int concatRef;
    private int concatTotal;
    private int concatPart;

    @JsonProperty(value="msisdn")
    public String getMsisdn() {
        return this.msisdn;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="type")
    public MessageType getType() {
        return this.type;
    }

    @JsonProperty(value="keyword")
    public String getKeyword() {
        return this.keyword;
    }

    @JsonProperty(value="message-timestamp")
    public Date getMessageTimestamp() {
        return this.messageTimestamp;
    }

    @JsonProperty(value="timestamp")
    public String getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="nonce")
    public String getNonce() {
        return this.nonce;
    }

    @JsonProperty(value="concat")
    public Boolean getConcat() {
        return this.concat;
    }

    @JsonProperty(value="concat-ref")
    public int getConcatRef() {
        return this.concatRef;
    }

    @JsonProperty(value="concat-total")
    public int getConcatTotal() {
        return this.concatTotal;
    }

    @JsonProperty(value="concat-part")
    public int getConcatPart() {
        return this.concatPart;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    @JsonProperty(value="udh")
    public String getUdh() {
        return this.udh;
    }

    @Override
    public void updateFromJson(String json) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)dateFormat);
            mapper.readerForUpdating((Object)this).readValue(json, MessageEvent.class);
        }
        catch (IOException jpe) {
            throw new VonageUnexpectedException("Failed to produce MessageEvent from json.", jpe);
        }
    }

    public static MessageEvent fromJson(String json) {
        return (MessageEvent)Jsonable.fromJson((String)json, (Jsonable[])new MessageEvent[0]);
    }
}

