/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.meetings;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CallbackUrls {
    private URI roomsCallbackUrl;
    private URI sessionsCallbackUrl;
    private URI recordingsCallbackUrl;

    protected CallbackUrls() {
    }

    CallbackUrls(Builder builder) {
        if (builder.roomsCallbackUrl != null) {
            this.roomsCallbackUrl = URI.create(builder.roomsCallbackUrl);
        }
        if (builder.sessionsCallbackUrl != null) {
            this.sessionsCallbackUrl = URI.create(builder.sessionsCallbackUrl);
        }
        if (builder.recordingsCallbackUrl != null) {
            this.recordingsCallbackUrl = URI.create(builder.recordingsCallbackUrl);
        }
    }

    @JsonProperty(value="rooms_callback_url")
    public URI getRoomsCallbackUrl() {
        return this.roomsCallbackUrl;
    }

    @JsonProperty(value="sessions_callback_url")
    public URI getSessionsCallbackUrl() {
        return this.sessionsCallbackUrl;
    }

    @JsonProperty(value="recordings_callback_url")
    public URI getRecordingsCallbackUrl() {
        return this.recordingsCallbackUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String roomsCallbackUrl;
        private String sessionsCallbackUrl;
        private String recordingsCallbackUrl;

        Builder() {
        }

        public Builder roomsCallbackUrl(String roomsCallbackUrl) {
            this.roomsCallbackUrl = roomsCallbackUrl;
            return this;
        }

        public Builder sessionsCallbackUrl(String sessionsCallbackUrl) {
            this.sessionsCallbackUrl = sessionsCallbackUrl;
            return this;
        }

        public Builder recordingsCallbackUrl(String recordingsCallbackUrl) {
            this.recordingsCallbackUrl = recordingsCallbackUrl;
            return this;
        }

        public CallbackUrls build() {
            return new CallbackUrls(this);
        }
    }
}

