/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.meetings;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.meetings.ThemeDomain;
import java.net.URI;
import java.util.UUID;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true, value={"theme_id"}, allowSetters=true)
public class Theme
implements Jsonable {
    static final Pattern COLOR_PATTERN = Pattern.compile("(#[a-fA-F0-9]{6}|[a-fA-F0-9]{3})");
    @JsonIgnore
    private boolean update = false;
    private UUID themeId;
    private UUID applicationId;
    private ThemeDomain domain;
    private String themeName;
    private String mainColor;
    private String accountId;
    private String shortCompanyUrl;
    private String brandText;
    private String brandImageColored;
    private String brandImageWhite;
    private String brandedFavicon;
    private URI brandImageColoredUrl;
    private URI brandImageWhiteUrl;
    private URI brandedFaviconUrl;

    protected Theme() {
    }

    Theme(Builder builder) {
        this.mainColor = builder.mainColor;
        if (this.mainColor != null && !COLOR_PATTERN.matcher(this.mainColor).matches()) {
            throw new IllegalArgumentException("Main color must be a valid hex pallet.");
        }
        this.brandText = builder.brandText;
        if (this.brandText != null) {
            if (this.brandText.length() > 200) {
                throw new IllegalArgumentException("Brand text cannot exceed 200 characters.");
            }
            if (this.brandText.trim().isEmpty()) {
                throw new IllegalArgumentException("Brand text cannot be blank.");
            }
        }
        if ((this.themeName = builder.themeName) != null) {
            if (this.themeName.length() > 200) {
                throw new IllegalArgumentException("Theme name cannot exceed 200 characters.");
            }
            if (this.themeName.trim().isEmpty()) {
                throw new IllegalArgumentException("Theme name cannot be blank.");
            }
        }
        if ((this.shortCompanyUrl = builder.shortCompanyUrl) != null) {
            if (this.shortCompanyUrl.length() > 128) {
                throw new IllegalArgumentException("Short company URL cannot exceed 128 characters.");
            }
            if (this.shortCompanyUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("Short company URL cannot be blank.");
            }
        }
    }

    @JsonIgnore
    void setThemeIdAndFlagUpdate(UUID themeId) {
        this.themeId = themeId;
        this.update = true;
    }

    @JsonProperty(value="theme_id")
    public UUID getThemeId() {
        return this.themeId;
    }

    @JsonProperty(value="theme_name")
    public String getThemeName() {
        return this.themeName;
    }

    @JsonProperty(value="domain")
    public ThemeDomain getDomain() {
        return this.domain;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="application_id")
    public UUID getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="main_color")
    public String getMainColor() {
        return this.mainColor;
    }

    @JsonProperty(value="short_company_url")
    public String getShortCompanyUrl() {
        return this.shortCompanyUrl;
    }

    @JsonProperty(value="brand_text")
    public String getBrandText() {
        return this.brandText;
    }

    @JsonProperty(value="brand_image_colored")
    public String getBrandImageColored() {
        return this.brandImageColored;
    }

    @JsonProperty(value="brand_image_white")
    public String getBrandImageWhite() {
        return this.brandImageWhite;
    }

    @JsonProperty(value="branded_favicon")
    public String getBrandedFavicon() {
        return this.brandedFavicon;
    }

    @JsonProperty(value="brand_image_colored_url")
    public URI getBrandImageColoredUrl() {
        return this.brandImageColoredUrl;
    }

    @JsonProperty(value="brand_image_white_url")
    public URI getBrandImageWhiteUrl() {
        return this.brandImageWhiteUrl;
    }

    @JsonProperty(value="branded_favicon_url")
    public URI getBrandedFaviconUrl() {
        return this.brandedFaviconUrl;
    }

    @Override
    public String toJson() {
        String json = Jsonable.super.toJson();
        if (this.update) {
            json = "{\"update_details\":" + json + "}";
            this.update = false;
        }
        return json;
    }

    public static Theme fromJson(String json) {
        return (Theme)Jsonable.fromJson((String)json, (Jsonable[])new Theme[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String themeName;
        private String mainColor;
        private String brandText;
        private String shortCompanyUrl;

        Builder() {
        }

        public Builder themeName(String themeName) {
            this.themeName = themeName;
            return this;
        }

        public Builder mainColor(String mainColor) {
            this.mainColor = mainColor;
            return this;
        }

        public Builder shortCompanyUrl(String shortCompanyUrl) {
            this.shortCompanyUrl = shortCompanyUrl;
            return this;
        }

        public Builder brandText(String brandText) {
            this.brandText = brandText;
            return this;
        }

        public Theme build() {
            return new Theme(this);
        }
    }
}

