/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageStatus;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.sms.SmsInboundMetadata;
import com.vonage.client.messages.whatsapp.Context;
import com.vonage.client.messages.whatsapp.ContextStatus;
import com.vonage.client.messages.whatsapp.Location;
import com.vonage.client.messages.whatsapp.Order;
import com.vonage.client.messages.whatsapp.Profile;
import com.vonage.client.messages.whatsapp.Referral;
import com.vonage.client.messages.whatsapp.Reply;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InboundMessage
implements Jsonable {
    @JsonAnySetter
    protected Map<String, Object> unknownProperties;
    @JsonProperty(value="whatsapp")
    private Whatsapp whatsapp;
    @JsonProperty(value="timestamp")
    protected Instant timestamp;
    @JsonProperty(value="channel")
    protected Channel channel;
    @JsonProperty(value="message_type")
    protected MessageType messageType;
    @JsonProperty(value="message_uuid")
    protected UUID messageUuid;
    @JsonProperty(value="to")
    protected String to;
    @JsonProperty(value="from")
    protected String from;
    @JsonProperty(value="client_ref")
    protected String clientRef;
    @JsonProperty(value="provider_message")
    String providerMessage;
    @JsonProperty(value="text")
    protected String text;
    @JsonProperty(value="image")
    protected UrlWrapperWithCaption image;
    @JsonProperty(value="audio")
    protected UrlWrapper audio;
    @JsonProperty(value="video")
    protected UrlWrapper video;
    @JsonProperty(value="file")
    protected UrlWrapper file;
    @JsonProperty(value="vcard")
    protected UrlWrapper vcard;
    @JsonProperty(value="sticker")
    protected UrlWrapper sticker;
    @JsonProperty(value="profile")
    protected Profile whatsappProfile;
    @JsonProperty(value="context_status")
    protected ContextStatus whatsappContextStatus;
    @JsonProperty(value="context")
    protected Context whatsappContext;
    @JsonProperty(value="location")
    protected Location whatsappLocation;
    @JsonProperty(value="reply")
    protected Reply whatsappReply;
    @JsonProperty(value="order")
    protected Order whatsappOrder;
    @JsonProperty(value="usage")
    protected MessageStatus.Usage usage;
    @JsonProperty(value="sms")
    protected SmsInboundMetadata smsMetadata;

    protected InboundMessage() {
    }

    @JsonAnyGetter
    public Map<String, ?> getUnmappedProperties() {
        return this.unknownProperties;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getClientRef() {
        return this.clientRef;
    }

    public String getText() {
        return this.text;
    }

    public URI getImageUrl() {
        return this.image != null ? this.image.url : null;
    }

    public String getImageCaption() {
        return this.image != null ? this.image.caption : null;
    }

    public URI getAudioUrl() {
        return this.audio != null ? this.audio.url : null;
    }

    public URI getVideoUrl() {
        return this.video != null ? this.video.url : null;
    }

    public URI getFileUrl() {
        return this.file != null ? this.file.url : null;
    }

    public URI getVcardUrl() {
        return this.vcard != null ? this.vcard.url : null;
    }

    public URI getStickerUrl() {
        return this.sticker != null ? this.sticker.url : null;
    }

    public String getProviderMessage() {
        return this.providerMessage;
    }

    public Location getWhatsappLocation() {
        return this.whatsappLocation;
    }

    public Reply getWhatsappReply() {
        return this.whatsappReply;
    }

    public Order getWhatsappOrder() {
        return this.whatsappOrder;
    }

    public Profile getWhatsappProfile() {
        return this.whatsappProfile;
    }

    public Context getWhatsappContext() {
        return this.whatsappContext;
    }

    public ContextStatus getWhatsappContextStatus() {
        return this.whatsappContextStatus;
    }

    public MessageStatus.Usage getUsage() {
        return this.usage;
    }

    public SmsInboundMetadata getSmsMetadata() {
        return this.smsMetadata;
    }

    @JsonIgnore
    public Referral getWhatsappReferral() {
        return this.whatsapp != null ? this.whatsapp.referral : null;
    }

    public static InboundMessage fromJson(String json) {
        return (InboundMessage)Jsonable.fromJson((String)json, (Jsonable[])new InboundMessage[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    protected static class UrlWrapperWithCaption
    extends UrlWrapper {
        @JsonProperty(value="caption")
        protected String caption;

        protected UrlWrapperWithCaption() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    protected static class UrlWrapper {
        @JsonProperty(value="url")
        protected URI url;

        protected UrlWrapper() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    protected static class Whatsapp {
        @JsonProperty(value="referral")
        protected Referral referral;

        protected Whatsapp() {
        }
    }
}

