/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.common.E164;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.MessagesVersion;
import java.net.URI;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class MessageRequest
implements Jsonable {
    final MessageType messageType;
    final Channel channel;
    final String clientRef;
    final URI webhookUrl;
    final MessagesVersion webhookVersion;
    protected String from;
    protected String to;

    protected MessageRequest(Builder<?, ?> builder, Channel channel, MessageType messageType) {
        this.messageType = Objects.requireNonNull(messageType, "Message type cannot be null");
        this.channel = Objects.requireNonNull(channel, "Channel cannot be null");
        if (!this.channel.getSupportedOutboundMessageTypes().contains((Object)this.messageType)) {
            throw new IllegalArgumentException((Object)((Object)this.messageType) + " cannot be sent via " + (Object)((Object)this.channel));
        }
        this.clientRef = this.validateClientReference(builder.clientRef);
        this.from = builder.from;
        this.to = builder.to;
        this.webhookUrl = builder.webhookUrl;
        this.webhookVersion = builder.webhookVersion;
        this.validateSenderAndRecipient(this.from, this.to);
    }

    protected String validateClientReference(String clientRef) {
        int limit = 100;
        if (clientRef != null && clientRef.length() > limit) {
            throw new IllegalArgumentException("Client reference cannot be longer than " + limit + " characters");
        }
        return clientRef;
    }

    protected void validateSenderAndRecipient(String from, String to) throws IllegalArgumentException {
        if (from == null || from.isEmpty()) {
            throw new IllegalArgumentException("Sender cannot be empty");
        }
        this.to = new E164(to).toString();
    }

    @JsonProperty(value="message_type")
    public MessageType getMessageType() {
        return this.messageType;
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="client_ref")
    public String getClientRef() {
        return this.clientRef;
    }

    @JsonProperty(value="webhook_url")
    public URI getWebhookUrl() {
        return this.webhookUrl;
    }

    @JsonProperty(value="webhook_version")
    public MessagesVersion getWebhookVersion() {
        return this.webhookVersion;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.toJson();
    }

    public static abstract class Builder<M extends MessageRequest, B extends Builder<? extends M, ? extends B>> {
        protected String from;
        protected String to;
        protected String clientRef;
        protected URI webhookUrl;
        protected MessagesVersion webhookVersion;

        protected Builder() {
        }

        public B from(String from) {
            this.from = from;
            return (B)this;
        }

        public B to(String to) {
            this.to = to;
            return (B)this;
        }

        public B clientRef(String clientRef) {
            this.clientRef = clientRef;
            return (B)this;
        }

        public B webhookUrl(String webhookUrl) {
            return this.webhookUrl(URI.create(webhookUrl));
        }

        private B webhookUrl(URI webhookUrl) {
            this.webhookUrl = webhookUrl;
            return (B)this;
        }

        public B webhookVersion(MessagesVersion webhookVersion) {
            this.webhookVersion = webhookVersion;
            return (B)this;
        }

        public abstract M build();
    }
}

