/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.Jsonable;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.whatsapp.ConversationType;
import java.net.URI;
import java.time.Instant;
import java.util.Currency;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MessageStatus
implements Jsonable {
    @JsonAnySetter
    protected Map<String, Object> unknownProperties;
    @JsonProperty(value="timestamp")
    protected Instant timestamp;
    @JsonProperty(value="message_uuid")
    protected UUID messageUuid;
    @JsonProperty(value="to")
    protected String to;
    @JsonProperty(value="from")
    protected String from;
    @JsonProperty(value="status")
    protected Status status;
    @JsonProperty(value="channel")
    protected Channel channel;
    @JsonProperty(value="client_ref")
    protected String clientRef;
    @JsonProperty(value="error")
    protected Error error;
    @JsonProperty(value="usage")
    protected Usage usage;
    @JsonProperty(value="destination")
    private Destination destination;
    @JsonProperty(value="sms")
    private Sms sms;
    @JsonProperty(value="whatsapp")
    private Whatsapp whatsapp;

    protected MessageStatus() {
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Status getStatus() {
        return this.status;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getClientRef() {
        return this.clientRef;
    }

    public Error getError() {
        return this.error;
    }

    public Usage getUsage() {
        return this.usage;
    }

    @JsonIgnore
    public String getDestinationNetworkCode() {
        return this.destination != null ? this.destination.networkCode : null;
    }

    @JsonIgnore
    public Integer getSmsTotalCount() {
        return this.sms != null ? this.sms.countTotal : null;
    }

    @JsonIgnore
    public ConversationType getWhatsappConversationType() {
        return this.whatsapp != null && this.whatsapp.conversation != null && this.whatsapp.conversation.origin != null ? this.whatsapp.conversation.origin.type : null;
    }

    @JsonIgnore
    public String getWhatsappConversationId() {
        return this.whatsapp != null && this.whatsapp.conversation != null ? this.whatsapp.conversation.id : null;
    }

    public Map<String, ?> getAdditionalProperties() {
        return this.unknownProperties;
    }

    public static MessageStatus fromJson(String json) {
        return (MessageStatus)Jsonable.fromJson((String)json, (Jsonable[])new MessageStatus[0]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.toJson();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageStatus that = (MessageStatus)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.messageUuid, that.messageUuid) && Objects.equals(this.to, that.to) && Objects.equals(this.from, that.from) && this.status == that.status && this.channel == that.channel && Objects.equals(this.clientRef, that.clientRef) && Objects.equals(this.error, that.error) && Objects.equals(this.usage, that.usage) && Objects.equals(this.getDestinationNetworkCode(), that.getDestinationNetworkCode()) && Objects.equals(this.getSmsTotalCount(), that.getSmsTotalCount()) && Objects.equals(this.getWhatsappConversationId(), that.getWhatsappConversationId()) && Objects.equals((Object)this.getWhatsappConversationType(), (Object)that.getWhatsappConversationType());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.messageUuid, this.to, this.from, this.status, this.channel, this.clientRef, this.error, this.usage, this.getDestinationNetworkCode(), this.getSmsTotalCount()});
    }

    public static enum Status {
        SUBMITTED,
        DELIVERED,
        REJECTED,
        UNDELIVERABLE,
        READ;


        @JsonCreator
        public static Status fromString(String value) {
            if (value == null) {
                return null;
            }
            return Status.valueOf(value.toUpperCase());
        }

        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Error {
        @JsonProperty(value="type")
        URI type;
        @JsonProperty(value="title")
        String title;
        @JsonProperty(value="detail")
        String detail;
        @JsonProperty(value="instance")
        String instance;

        public URI getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getInstance() {
            return this.instance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return Objects.equals(this.type, error.type) && Objects.equals(this.title, error.title) && Objects.equals(this.detail, error.detail) && Objects.equals(this.instance, error.instance);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.title, this.detail, this.instance);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " {type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", detail='" + this.detail + '\'' + ", instance='" + this.instance + "'}";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Usage {
        @JsonProperty(value="price")
        double price;
        @JsonProperty(value="currency")
        Currency currency;

        void setCurrency(String currency) {
            this.currency = Currency.getInstance(currency);
        }

        public Currency getCurrency() {
            return this.currency;
        }

        void setPrice(String price) {
            this.price = Double.parseDouble(price);
        }

        public double getPrice() {
            return this.price;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Usage usage = (Usage)o;
            return Double.compare(usage.price, this.price) == 0 && Objects.equals(this.currency, usage.currency);
        }

        public int hashCode() {
            return Objects.hash(this.price, this.currency);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " {price=" + this.price + ", currency=" + this.currency + '}';
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Destination {
        @JsonProperty(value="network_code")
        String networkCode;

        Destination() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Sms {
        @JsonProperty(value="count_total")
        Integer countTotal;

        Sms() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Whatsapp {
        @JsonProperty(value="conversation")
        Conversation conversation;

        Whatsapp() {
        }

        static class Conversation {
            @JsonProperty(value="id")
            String id;
            @JsonProperty(value="origin")
            Origin origin;

            Conversation() {
            }

            static class Origin {
                @JsonProperty(value="type")
                ConversationType type;

                Origin() {
                }
            }
        }
    }
}

