/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageResponse;
import com.vonage.client.messages.MessageResponseException;
import com.vonage.jwt.Jwt;
import java.util.function.Function;

public class MessagesClient {
    private boolean sandbox = false;
    final RestEndpoint<MessageRequest, MessageResponse> sendMessage;
    final RestEndpoint<MessageRequest, MessageResponse> sendMessageSandbox;

    public MessagesClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<HttpWrapper, String> basePathGetter, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(MessageResponseException.class).wrapper(var4_4).requestMethod(HttpMethod.POST).authMethod(JWTAuthMethod.class, TokenAuthMethod.class).pathGetter((de, req) -> (String)basePathGetter.apply(de.getHttpWrapper()) + "/v1/messages"));
            }
        }
        this.sendMessage = new Endpoint(hw -> hw.getHttpConfig().getApiBaseUri(), (Object[])new MessageResponse[0]);
        this.sendMessageSandbox = new Endpoint(hw -> "https://messages-sandbox.nexmo.com", (Object[])new MessageResponse[0]);
    }

    public MessageResponse sendMessage(MessageRequest request) throws VonageClientException, VonageResponseParseException {
        return (this.sandbox ? this.sendMessageSandbox : this.sendMessage).execute(request);
    }

    public MessagesClient useSandboxEndpoint() {
        this.sandbox = true;
        return this;
    }

    public MessagesClient useRegularEndpoint() {
        this.sandbox = false;
        return this;
    }

    public static boolean verifySignature(String jwt, String secret) {
        return Jwt.verifySignature((String)jwt, (String)secret);
    }
}

