/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.sms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.sms.EncodingType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class OutboundSettings {
    final EncodingType encodingType;
    final String contentId;
    final String entityId;

    private OutboundSettings(EncodingType encodingType, String contentId, String entityId) {
        this.encodingType = encodingType;
        this.contentId = contentId;
        this.entityId = entityId;
    }

    static OutboundSettings construct(EncodingType encodingType, String contentId, String entityId) {
        if (encodingType == null && contentId == null && entityId == null) {
            return null;
        }
        if (contentId != null && contentId.trim().isEmpty()) {
            throw new IllegalArgumentException("Content ID cannot be blank.");
        }
        if (entityId != null && entityId.trim().isEmpty()) {
            throw new IllegalArgumentException("Entity ID cannot be blank.");
        }
        return new OutboundSettings(encodingType, contentId, entityId);
    }

    @JsonProperty(value="encoding_type")
    public EncodingType getEncodingType() {
        return this.encodingType;
    }

    @JsonProperty(value="content_id")
    public String getContentId() {
        return this.contentId;
    }

    @JsonProperty(value="entity_id")
    public String getEntityId() {
        return this.entityId;
    }
}

