/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.sms;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageRequest;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.Text;
import com.vonage.client.messages.sms.EncodingType;
import com.vonage.client.messages.sms.OutboundSettings;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class SmsTextRequest
extends MessageRequest {
    final String text;
    final Integer ttl;
    final OutboundSettings sms;

    SmsTextRequest(Builder builder) {
        super(builder, Channel.SMS, MessageType.TEXT);
        this.text = new Text(builder.text, 1000).toString();
        this.ttl = builder.ttl;
        if (this.ttl != null && this.ttl < 1) {
            throw new IllegalArgumentException("TTL must be positive.");
        }
        this.sms = OutboundSettings.construct(builder.encodingType, builder.contentId, builder.entityId);
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="sms")
    public OutboundSettings getMessageSettings() {
        return this.sms;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends MessageRequest.Builder<SmsTextRequest, Builder> {
        String text;
        String contentId;
        String entityId;
        Integer ttl;
        EncodingType encodingType;

        Builder() {
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder encodingType(EncodingType encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        @Override
        public SmsTextRequest build() {
            return new SmsTextRequest(this);
        }
    }
}

