/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.Text;
import com.vonage.client.messages.viber.ViberRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ViberTextRequest
extends ViberRequest {
    final String text;

    ViberTextRequest(Builder builder) {
        super(builder, MessageType.TEXT);
        this.text = new Text(builder.text, 1000).toString();
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ViberRequest.Builder<ViberTextRequest, Builder> {
        String text;

        Builder() {
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public Builder actionUrl(String actionUrl) {
            return (Builder)super.actionUrl(actionUrl);
        }

        @Override
        public Builder actionText(String actionText) {
            return (Builder)super.actionText(actionText);
        }

        @Override
        public ViberTextRequest build() {
            return new ViberTextRequest(this);
        }
    }
}

