/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.viber.ViberRequest;
import com.vonage.client.messages.viber.Video;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ViberVideoRequest
extends ViberRequest {
    final Video video;

    ViberVideoRequest(Builder builder) {
        super(builder, MessageType.VIDEO);
        Objects.requireNonNull(builder.duration, "Duration is required.");
        Objects.requireNonNull(builder.fileSize, "File size is required.");
        this.video = new Video(builder.url, builder.thumbUrl, builder.caption);
    }

    @JsonProperty(value="video")
    public Video getVideo() {
        return this.video;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ViberRequest.Builder<ViberVideoRequest, Builder> {
        String url;
        String thumbUrl;
        String caption;

        Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder thumbUrl(String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder fileSize(int fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public ViberVideoRequest build() {
            return new ViberVideoRequest(this);
        }
    }
}

