/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.whatsapp.Location;
import com.vonage.client.messages.whatsapp.WhatsappRequest;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WhatsappLocationRequest
extends WhatsappRequest {
    final Map<String, Object> custom = new LinkedHashMap<String, Object>(4);

    WhatsappLocationRequest(Builder builder) {
        super(builder, MessageType.CUSTOM);
        this.custom.put("type", "location");
        this.custom.put("location", new Location(builder));
    }

    @JsonProperty(value="custom")
    public Map<?, ?> getCustom() {
        return this.custom;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappLocationRequest, Builder> {
        String name;
        String address;
        String text;
        Double latitude;
        Double longitude;

        Builder() {
        }

        public Builder latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public Builder longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder address(String address) {
            this.address = address;
            return this;
        }

        @Override
        public WhatsappLocationRequest build() {
            return new WhatsappLocationRequest(this);
        }
    }
}

