/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.MessagePayload;
import com.vonage.client.messages.whatsapp.WhatsappRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WhatsappVideoRequest
extends WhatsappRequest {
    final MessagePayload video;

    WhatsappVideoRequest(Builder builder) {
        super(builder, MessageType.VIDEO);
        this.video = new MessagePayload(builder.url, builder.caption);
        this.video.validateUrlExtension("mp4", "3gpp");
    }

    @JsonProperty(value="video")
    public MessagePayload getVideo() {
        return this.video;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappVideoRequest, Builder> {
        String url;
        String caption;

        Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @Override
        public WhatsappVideoRequest build() {
            return new WhatsappVideoRequest(this);
        }
    }
}

