/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.numbers.BuyNumberRequest;
import com.vonage.client.numbers.CancelNumberRequest;
import com.vonage.client.numbers.ListNumbersFilter;
import com.vonage.client.numbers.ListNumbersResponse;
import com.vonage.client.numbers.NumbersResponseException;
import com.vonage.client.numbers.SearchNumbersFilter;
import com.vonage.client.numbers.SearchNumbersResponse;
import com.vonage.client.numbers.UpdateNumberRequest;

public class NumbersClient {
    final RestEndpoint<ListNumbersFilter, ListNumbersResponse> listNumbers;
    final RestEndpoint<SearchNumbersFilter, SearchNumbersResponse> searchNumbers;
    final RestEndpoint<CancelNumberRequest, Void> cancelNumber;
    final RestEndpoint<BuyNumberRequest, Void> buyNumber;
    final RestEndpoint<UpdateNumberRequest, Void> updateNumber;

    public NumbersClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(String path, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(NumbersResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(TokenAuthMethod.class, new Class[0]).applyAsBasicAuth().contentTypeHeader(method == HttpMethod.POST ? "application/x-www-form-urlencoded" : null).pathGetter((de, req) -> de.getHttpWrapper().getHttpConfig().getRestBaseUri() + "/" + path));
            }
        }
        this.listNumbers = new Endpoint("account/numbers", HttpMethod.GET, (Object[])new ListNumbersResponse[0]);
        this.searchNumbers = new Endpoint("number/search", HttpMethod.GET, (Object[])new SearchNumbersResponse[0]);
        this.cancelNumber = new Endpoint("number/cancel", HttpMethod.POST, (Object[])new Void[0]);
        this.buyNumber = new Endpoint("number/buy", HttpMethod.POST, (Object[])new Void[0]);
        this.updateNumber = new Endpoint("number/update", HttpMethod.POST, (Object[])new Void[0]);
    }

    public ListNumbersResponse listNumbers() throws VonageResponseParseException, VonageClientException {
        return this.listNumbers(new ListNumbersFilter());
    }

    public ListNumbersResponse listNumbers(ListNumbersFilter filter) throws VonageResponseParseException, VonageClientException {
        return this.listNumbers.execute(filter);
    }

    public SearchNumbersResponse searchNumbers(String country) throws VonageResponseParseException, VonageClientException {
        return this.searchNumbers(new SearchNumbersFilter(country));
    }

    public SearchNumbersResponse searchNumbers(SearchNumbersFilter filter) throws VonageResponseParseException, VonageClientException {
        return this.searchNumbers.execute(filter);
    }

    public void buyNumber(String country, String msisdn) throws VonageResponseParseException, VonageClientException {
        this.buyNumber.execute(new BuyNumberRequest(country, msisdn));
    }

    public void cancelNumber(String country, String msisdn) throws VonageResponseParseException, VonageClientException {
        this.cancelNumber.execute(new CancelNumberRequest(country, msisdn));
    }

    public void updateNumber(UpdateNumberRequest request) throws VonageResponseParseException, VonageClientException {
        this.updateNumber.execute(request);
    }

    public void linkNumber(String msisdn, String country, String appId) throws VonageResponseParseException, VonageClientException {
        UpdateNumberRequest request = new UpdateNumberRequest(msisdn, country);
        request.setVoiceCallbackType(UpdateNumberRequest.CallbackType.APP);
        request.setVoiceCallbackValue(appId);
        this.updateNumber(request);
    }
}

