/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.proactiveconnect;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.proactiveconnect.Datasource;
import com.vonage.client.proactiveconnect.ListAttribute;
import com.vonage.client.proactiveconnect.SyncStatus;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContactsList
implements Jsonable {
    UUID id;
    private String name;
    private String description;
    private List<String> tags;
    private List<ListAttribute> attributes;
    private Datasource datasource;
    private Instant createdAt;
    private Instant updatedAt;
    private Integer itemsCount;
    private SyncStatus syncStatus;

    ContactsList() {
    }

    ContactsList(Builder builder) {
        this.name = builder.name;
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("List name is required.");
        }
        this.tags = builder.tags;
        if (this.tags != null) {
            if (this.tags.size() > 10) {
                throw new IllegalStateException("Too many tags provided. Maximum is 10.");
            }
            for (String tag : this.tags) {
                if (tag == null || tag.trim().isEmpty()) {
                    throw new IllegalArgumentException("Tag cannot be null or blank.");
                }
                if (tag.length() <= 15) continue;
                throw new IllegalArgumentException("Tag cannot be longer than 15 characters.");
            }
        }
        this.description = builder.description;
        this.attributes = builder.attributes;
        this.datasource = builder.datasource;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="attributes")
    public List<ListAttribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="datasource")
    public Datasource getDatasource() {
        return this.datasource;
    }

    @JsonProperty(value="created_at")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="items_count")
    public Integer getItemsCount() {
        return this.itemsCount;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="sync_status")
    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public static ContactsList fromJson(String json) {
        return (ContactsList)Jsonable.fromJson((String)json, (Jsonable[])new ContactsList[0]);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private final String name;
        private String description;
        private List<String> tags;
        private List<ListAttribute> attributes;
        private Datasource datasource;

        Builder(String name) {
            this.name = name;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder tags(String ... tags) {
            return this.tags(Arrays.asList(tags));
        }

        public Builder attributes(ListAttribute ... attributes) {
            return this.attributes(Arrays.asList(attributes));
        }

        public Builder attributes(List<ListAttribute> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder datasource(Datasource datasource) {
            this.datasource = datasource;
            return this;
        }

        public ContactsList build() {
            return new ContactsList(this);
        }
    }
}

