/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.proactiveconnect;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HalPageResponse;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.proactiveconnect.ContactsList;
import com.vonage.client.proactiveconnect.Event;
import com.vonage.client.proactiveconnect.HalRequestWrapper;
import com.vonage.client.proactiveconnect.ListEventsFilter;
import com.vonage.client.proactiveconnect.ListEventsResponse;
import com.vonage.client.proactiveconnect.ListItem;
import com.vonage.client.proactiveconnect.ListItemRequestWrapper;
import com.vonage.client.proactiveconnect.ListItemsResponse;
import com.vonage.client.proactiveconnect.ListListsResponse;
import com.vonage.client.proactiveconnect.ProactiveConnectResponseException;
import com.vonage.client.proactiveconnect.SortOrder;
import com.vonage.client.proactiveconnect.UploadListItemsRequestWrapper;
import com.vonage.client.proactiveconnect.UploadListItemsResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class ProactiveConnectClient {
    final RestEndpoint<ContactsList, ContactsList> createList;
    final RestEndpoint<ContactsList, ContactsList> updateList;
    final RestEndpoint<UUID, ContactsList> getList;
    final RestEndpoint<UUID, Void> deleteList;
    final RestEndpoint<UUID, Void> clearList;
    final RestEndpoint<UUID, Void> fetchList;
    final RestEndpoint<HalRequestWrapper, ListListsResponse> listLists;
    final RestEndpoint<HalRequestWrapper, ListItemsResponse> listItems;
    final RestEndpoint<ListItemRequestWrapper, ListItem> createListItem;
    final RestEndpoint<ListItemRequestWrapper, ListItem> getListItem;
    final RestEndpoint<ListItemRequestWrapper, ListItem> updateListItem;
    final RestEndpoint<ListItemRequestWrapper, Void> deleteListItem;
    final RestEndpoint<UUID, byte[]> downloadListItems;
    final RestEndpoint<UploadListItemsRequestWrapper, UploadListItemsResponse> uploadListItems;
    final RestEndpoint<ListEventsFilter, ListEventsResponse> listEvents;

    public ProactiveConnectClient(final HttpWrapper wrapper) {
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).authMethod(JWTAuthMethod.class, new Class[0]).responseExceptionType(ProactiveConnectResponseException.class).requestMethod(method).wrapper(var5_5).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getApiEuBaseUri();
                    return base + "/v0.1/bulk/" + (String)pathGetter.apply(req);
                }));
            }
        }
        this.createList = new Endpoint(req -> "lists", HttpMethod.POST, (Object[])new ContactsList[0]);
        this.getList = new Endpoint(listId -> "lists/" + listId, HttpMethod.GET, (Object[])new ContactsList[0]);
        this.updateList = new Endpoint(list -> "lists/" + list.getId(), HttpMethod.PUT, (Object[])new ContactsList[0]);
        this.deleteList = new Endpoint(listId -> "lists/" + listId, HttpMethod.DELETE, (Object[])new Void[0]);
        this.clearList = new Endpoint(listId -> "lists/" + listId + "/clear", HttpMethod.POST, (Object[])new Void[0]);
        this.fetchList = new Endpoint(listId -> "lists/" + listId + "/fetch", HttpMethod.POST, (Object[])new Void[0]);
        this.listLists = new Endpoint(req -> "lists", HttpMethod.GET, (Object[])new ListListsResponse[0]);
        this.listItems = new Endpoint(req -> "lists/" + req.id + "/items", HttpMethod.GET, (Object[])new ListItemsResponse[0]);
        this.createListItem = new Endpoint(req -> "lists/" + req.listId + "/items", HttpMethod.POST, (Object[])new ListItem[0]);
        this.getListItem = new Endpoint(req -> "lists/" + req.listId + "/items/" + req.itemId, HttpMethod.GET, (Object[])new ListItem[0]);
        this.updateListItem = new Endpoint(req -> "lists/" + req.listId + "/items/" + req.itemId, HttpMethod.PUT, (Object[])new ListItem[0]);
        this.deleteListItem = new Endpoint(req -> "lists/" + req.listId + "/items/" + req.itemId, HttpMethod.DELETE, (Object[])new Void[0]);
        this.downloadListItems = new Endpoint(listId -> "lists/" + listId + "/items/download", HttpMethod.GET, (Object[])new byte[0][]);
        this.uploadListItems = new Endpoint(req -> "lists/" + req.listId + "/items/import", HttpMethod.POST, (Object[])new UploadListItemsResponse[0]);
        this.listEvents = new Endpoint(req -> "events", HttpMethod.GET, (Object[])new ListEventsResponse[0]);
    }

    private UUID validateUuid(String name, UUID uuid) {
        return Objects.requireNonNull(uuid, name + " is required.");
    }

    private <R extends HalPageResponse> R halRequest(RestEndpoint<HalRequestWrapper, R> endpoint, String id, Integer page, Integer pageSize, SortOrder order) {
        if (page != null && page < 1) {
            throw new IllegalArgumentException("Page number must be positive.");
        }
        if (pageSize != null && pageSize < 1) {
            throw new IllegalArgumentException("Page size must be positive.");
        }
        return (R)((HalPageResponse)endpoint.execute(new HalRequestWrapper(page, pageSize, order, id)));
    }

    public ContactsList createList(ContactsList list) {
        return this.createList.execute(Objects.requireNonNull(list, "List structure is required."));
    }

    public ContactsList getList(UUID listId) {
        return this.getList.execute(this.validateUuid("List ID", listId));
    }

    public ContactsList updateList(UUID listId, ContactsList updatedList) {
        Objects.requireNonNull(updatedList, "List structure is required.");
        updatedList.id = this.validateUuid("List ID", listId);
        return this.updateList.execute(updatedList);
    }

    public void deleteList(UUID listId) {
        this.deleteList.execute(this.validateUuid("List ID", listId));
    }

    public void clearList(UUID listId) {
        this.clearList.execute(this.validateUuid("List ID", listId));
    }

    public void fetchList(UUID listId) {
        this.fetchList.execute(this.validateUuid("List ID", listId));
    }

    public List<ContactsList> listLists() {
        return this.halRequest(this.listLists, null, 1, 1000, null).getLists();
    }

    public ListListsResponse listLists(int page, int pageSize, SortOrder order) {
        return this.halRequest(this.listLists, null, page, pageSize, order);
    }

    public ListItem createListItem(UUID listId, Map<String, ?> data) {
        return this.createListItem.execute(new ListItemRequestWrapper(this.validateUuid("List ID", listId), null, Objects.requireNonNull(data, "List data is required.")));
    }

    public ListItem getListItem(UUID listId, UUID itemId) {
        return this.getListItem.execute(new ListItemRequestWrapper(this.validateUuid("List ID", listId), this.validateUuid("Item ID", itemId), null));
    }

    public ListItem updateListItem(UUID listId, UUID itemId, Map<String, ?> data) {
        return this.updateListItem.execute(new ListItemRequestWrapper(this.validateUuid("List ID", listId), this.validateUuid("Item ID", itemId), Objects.requireNonNull(data, "List item data is required.")));
    }

    public void deleteListItem(UUID listId, UUID itemId) {
        this.deleteListItem.execute(new ListItemRequestWrapper(this.validateUuid("List ID", listId), this.validateUuid("Item ID", itemId), null));
    }

    public String downloadListItems(UUID listId) {
        return new String(this.downloadListItems.execute(this.validateUuid("List ID", listId)));
    }

    public void downloadListItems(UUID listId, Path file) {
        try {
            Files.write(Objects.requireNonNull(file, "CSV file is required."), this.downloadListItems.execute(this.validateUuid("List ID", listId)), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new VonageUnexpectedException("Couldn't write list '" + listId + "' to file '" + file + "'", ex);
        }
    }

    public UploadListItemsResponse uploadListItems(UUID listId, Path csvFile) {
        try {
            byte[] data = Files.readAllBytes(csvFile);
            return this.uploadListItems.execute(new UploadListItemsRequestWrapper(this.validateUuid("List ID", listId), data));
        }
        catch (IOException ex) {
            throw new VonageClientException("Could not read from file.", ex);
        }
    }

    public List<ListItem> listItems(UUID listId) {
        return this.halRequest(this.listItems, this.validateUuid("List ID", listId).toString(), 1, 1000, null).getItems();
    }

    public ListItemsResponse listItems(UUID listId, int page, int pageSize, SortOrder order) {
        return this.halRequest(this.listItems, this.validateUuid("List ID", listId).toString(), page, pageSize, order);
    }

    public List<Event> listEvents(ListEventsFilter filter) {
        return this.listEvents.execute(filter != null ? filter : ListEventsFilter.builder().build()).getEvents();
    }
}

