/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.redact;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageBadRequestException;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.redact.RedactRequest;

public class RedactClient {
    final RestEndpoint<RedactRequest, Void> redactTransaction;

    public RedactClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(String path, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).wrapper(var5_5).requestMethod(method).applyAsBasicAuth().responseExceptionType(VonageBadRequestException.class).authMethod(SignatureAuthMethod.class, TokenAuthMethod.class).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getVersionedApiBaseUri("v1");
                    return base + path;
                }));
            }
        }
        this.redactTransaction = new Endpoint("/redact/transaction", HttpMethod.POST, (Object[])new Void[0]);
    }

    public void redactTransaction(String id, RedactRequest.Product product) throws VonageResponseParseException, VonageClientException {
        this.redactTransaction(new RedactRequest(id, product));
    }

    public void redactTransaction(String id, RedactRequest.Product product, RedactRequest.Type type) throws VonageResponseParseException, VonageClientException {
        RedactRequest request = new RedactRequest(id, product);
        request.setType(type);
        this.redactTransaction(request);
    }

    public void redactTransaction(RedactRequest redactRequest) throws VonageResponseParseException, VonageClientException {
        if (redactRequest.getId() == null || redactRequest.getProduct() == null) {
            throw new IllegalArgumentException("Redact transaction id and product are required.");
        }
        if (redactRequest.getProduct() == RedactRequest.Product.SMS && redactRequest.getType() == null) {
            throw new IllegalArgumentException("Redacting SMS requires a type.");
        }
        this.redactTransaction.execute(redactRequest);
    }
}

