/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateSubaccountRequest
implements Jsonable {
    String primaryAccountApiKey;
    private final String name;
    private final String secret;
    private final Boolean usePrimaryAccountBalance;

    CreateSubaccountRequest(Builder builder) {
        this.name = builder.name;
        if (this.name == null || this.name.trim().isEmpty() || this.name.length() > 80) {
            throw new IllegalArgumentException("Name must be between 1 and 80 characters long.");
        }
        this.secret = builder.secret;
        if (this.secret != null && (this.secret.trim().length() < 8 || this.secret.length() > 25)) {
            throw new IllegalArgumentException("Secret must be between 8 and 25 characters long.");
        }
        this.usePrimaryAccountBalance = builder.usePrimaryAccountBalance;
    }

    @JsonProperty(value="primary_account_api_key")
    String getPrimaryAccountApiKey() {
        return this.primaryAccountApiKey;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="use_primary_account_balance")
    public Boolean getUsePrimaryAccountBalance() {
        return this.usePrimaryAccountBalance;
    }

    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String secret;
        private Boolean usePrimaryAccountBalance;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder usePrimaryAccountBalance(boolean usePrimaryAccountBalance) {
            this.usePrimaryAccountBalance = usePrimaryAccountBalance;
            return this;
        }

        public Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public CreateSubaccountRequest build() {
            return new CreateSubaccountRequest(this);
        }
    }
}

