/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.subaccounts.AbstractTransfer;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MoneyTransfer
extends AbstractTransfer {
    private UUID id;
    private Instant createdAt;
    private BigDecimal amount;
    private String reference;

    protected MoneyTransfer() {
    }

    protected MoneyTransfer(Builder builder) {
        super(builder);
        this.amount = Objects.requireNonNull(builder.amount, "Amount is required.");
        this.reference = builder.reference;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="amount")
    public BigDecimal getAmount() {
        return this.amount;
    }

    @JsonProperty(value="reference")
    public String getReference() {
        return this.reference;
    }

    public static MoneyTransfer fromJson(String json) {
        return (MoneyTransfer)Jsonable.fromJson((String)json, (Jsonable[])new MoneyTransfer[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractTransfer.Builder<MoneyTransfer, Builder> {
        private BigDecimal amount;
        private String from;
        private String to;
        private String reference;

        Builder() {
        }

        public Builder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder amount(double amount) {
            return this.amount(BigDecimal.valueOf(amount));
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public MoneyTransfer build() {
            return new MoneyTransfer(this);
        }
    }
}

