/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.common.E164;
import com.vonage.client.subaccounts.AbstractTransfer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class NumberTransfer
extends AbstractTransfer {
    private String number;
    private String country;

    protected NumberTransfer() {
    }

    NumberTransfer(Builder builder) {
        super(builder);
        this.number = new E164(builder.number).toString();
        this.country = builder.country;
        if (this.country == null || this.country.trim().length() != 2) {
            throw new IllegalArgumentException("ISO 3166-1 alpha-2 country code is required.");
        }
    }

    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="number")
    public String getNumber() {
        return this.number;
    }

    public static NumberTransfer fromJson(String json) {
        return (NumberTransfer)Jsonable.fromJson((String)json, (Jsonable[])new NumberTransfer[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractTransfer.Builder<NumberTransfer, Builder> {
        private String number;
        private String country;

        Builder() {
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        @Override
        public NumberTransfer build() {
            return new NumberTransfer(this);
        }
    }
}

