/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.subaccounts;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.subaccounts.AbstractTransfer;
import com.vonage.client.subaccounts.Account;
import com.vonage.client.subaccounts.CreateSubaccountRequest;
import com.vonage.client.subaccounts.ListSubaccountsResponse;
import com.vonage.client.subaccounts.ListTransfersFilter;
import com.vonage.client.subaccounts.ListTransfersResponseWrapper;
import com.vonage.client.subaccounts.MoneyTransfer;
import com.vonage.client.subaccounts.NumberTransfer;
import com.vonage.client.subaccounts.SubaccountsResponseException;
import com.vonage.client.subaccounts.UpdateSubaccountRequest;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class SubaccountsClient {
    final RestEndpoint<CreateSubaccountRequest, Account> createSubaccount;
    final RestEndpoint<UpdateSubaccountRequest, Account> updateSubaccount;
    final RestEndpoint<Void, ListSubaccountsResponse> listSubaccounts;
    final RestEndpoint<String, Account> getSubaccount;
    final RestEndpoint<ListTransfersFilter, ListTransfersResponseWrapper> listBalanceTransfers;
    final RestEndpoint<ListTransfersFilter, ListTransfersResponseWrapper> listCreditTransfers;
    final RestEndpoint<MoneyTransfer, MoneyTransfer> transferBalance;
    final RestEndpoint<MoneyTransfer, MoneyTransfer> transferCredit;
    final RestEndpoint<NumberTransfer, NumberTransfer> transferNumber;

    public SubaccountsClient(final HttpWrapper wrapper) {
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(SubaccountsResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(TokenAuthMethod.class, new Class[0]).pathGetter((de, req) -> {
                    if (req instanceof CreateSubaccountRequest) {
                        CreateSubaccountRequest csr = (CreateSubaccountRequest)req;
                        csr.primaryAccountApiKey = de.getApplicationIdOrApiKey();
                    }
                    return String.format(de.getHttpWrapper().getHttpConfig().getApiBaseUri() + "/accounts/%s/", de.getApplicationIdOrApiKey()) + (String)pathGetter.apply(req);
                }));
            }
        }
        this.createSubaccount = new Endpoint(req -> "subaccounts", HttpMethod.POST, (Object[])new Account[0]);
        this.updateSubaccount = new Endpoint(req -> "subaccounts/" + req.subaccountApiKey, HttpMethod.PATCH, (Object[])new Account[0]);
        this.listSubaccounts = new Endpoint(req -> "subaccounts", HttpMethod.GET, (Object[])new ListSubaccountsResponse[0]);
        this.getSubaccount = new Endpoint(req -> "subaccounts/" + req, HttpMethod.GET, (Object[])new Account[0]);
        this.listBalanceTransfers = new Endpoint(req -> "balance-transfers", HttpMethod.GET, (Object[])new ListTransfersResponseWrapper[0]);
        this.listCreditTransfers = new Endpoint(req -> "credit-transfers", HttpMethod.GET, (Object[])new ListTransfersResponseWrapper[0]);
        this.transferBalance = new Endpoint(req -> "balance-transfers", HttpMethod.POST, (Object[])new MoneyTransfer[0]);
        this.transferCredit = new Endpoint(req -> "credit-transfers", HttpMethod.POST, (Object[])new MoneyTransfer[0]);
        this.transferNumber = new Endpoint(req -> "transfer-number", HttpMethod.POST, (Object[])new NumberTransfer[0]);
    }

    private <T> T requireRequest(T request) {
        return Objects.requireNonNull(request, "Request is required.");
    }

    public Account createSubaccount(CreateSubaccountRequest request) {
        return this.createSubaccount.execute(this.requireRequest(request));
    }

    public Account updateSubaccount(UpdateSubaccountRequest request) {
        return this.updateSubaccount.execute(this.requireRequest(request));
    }

    public ListSubaccountsResponse listSubaccounts() {
        return this.listSubaccounts.execute(null);
    }

    public Account getSubaccount(String subaccountApiKey) {
        return this.getSubaccount.execute(AbstractTransfer.validateAccountKey(subaccountApiKey, "Subaccount"));
    }

    public List<MoneyTransfer> listCreditTransfers() {
        return this.listCreditTransfers(ListTransfersFilter.builder().build());
    }

    public List<MoneyTransfer> listCreditTransfers(ListTransfersFilter filter) {
        return this.listCreditTransfers.execute(this.requireRequest(filter)).getCreditTransfers();
    }

    public List<MoneyTransfer> listBalanceTransfers() {
        return this.listBalanceTransfers(ListTransfersFilter.builder().build());
    }

    public List<MoneyTransfer> listBalanceTransfers(ListTransfersFilter filter) {
        return this.listBalanceTransfers.execute(this.requireRequest(filter)).getBalanceTransfers();
    }

    public MoneyTransfer transferCredit(MoneyTransfer request) {
        return this.transferCredit.execute(this.requireRequest(request));
    }

    public MoneyTransfer transferBalance(MoneyTransfer request) {
        return this.transferBalance.execute(this.requireRequest(request));
    }

    public NumberTransfer transferNumber(NumberTransfer request) {
        return this.transferNumber.execute(this.requireRequest(request));
    }
}

