/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.users.BaseUser;
import com.vonage.client.users.channels.Channel;
import com.vonage.client.users.channels.Channels;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class User
extends BaseUser {
    private String displayName;
    private URI imageUrl;
    private Channels channels;
    private Properties properties;

    User() {
    }

    User(Builder builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.imageUrl = builder.imageUrl;
        this.channels = builder.channels;
        if (builder.customData != null) {
            this.properties = new Properties();
            this.properties.customData = builder.customData;
        }
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="image_url")
    public URI getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty(value="properties")
    private Properties getProperties() {
        return this.properties;
    }

    @JsonIgnore
    public Map<String, ?> getCustomData() {
        return this.getProperties() != null ? this.properties.getCustomData() : null;
    }

    @JsonProperty(value="channels")
    public Channels getChannels() {
        return this.channels;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.displayName, user.displayName) && Objects.equals(this.imageUrl, user.imageUrl) && Objects.equals(this.channels, user.channels) && Objects.equals(this.getCustomData(), user.getCustomData());
    }

    @JsonCreator
    public static User fromJson(String json) {
        return (User)Jsonable.fromJson((String)json, (Jsonable[])new User[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String displayName;
        private URI imageUrl;
        private Map<String, ?> customData;
        private Channels channels;

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder imageUrl(String imageUrl) {
            this.imageUrl = URI.create(imageUrl);
            return this;
        }

        public Builder customData(Map<String, ?> customData) {
            this.customData = customData;
            return this;
        }

        public Builder channels(Channel ... channels) {
            return this.channels(Arrays.asList(channels));
        }

        public Builder channels(Collection<? extends Channel> channels) {
            this.channels = new Channels(channels);
            return this;
        }

        public User build() {
            return new User(this);
        }
    }

    public static class Properties {
        private Map<String, ?> customData;

        @JsonProperty(value="custom_data")
        public Map<String, ?> getCustomData() {
            return this.customData;
        }
    }
}

