/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.users.channels;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.users.channels.Channel;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sip
extends Channel {
    private URI uri;
    private String username;
    private String password;

    protected Sip() {
    }

    public Sip(String uri) {
        Objects.requireNonNull(uri, "SIP URI is required");
        if (!uri.startsWith("sip:") && !uri.startsWith("sips:")) {
            throw new IllegalArgumentException("Invalid protocol for SIP URI.");
        }
        this.uri = URI.create(uri);
    }

    public Sip(String uri, String username, String password) {
        this(uri);
        this.username = username;
        this.password = password;
        if (this.password != null && !password.isEmpty() && username == null) {
            throw new IllegalArgumentException("Username should be provided along with password.");
        }
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sip sip = (Sip)o;
        return Objects.equals(this.uri, sip.uri) && Objects.equals(this.username, sip.username) && Objects.equals(this.password, sip.password);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.username, this.password);
    }
}

