/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.common.E164;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class BaseRequest
implements QueryParamsRequest {
    private final String number;
    private final String country;
    private final Integer length;
    private final Integer pinExpiry;
    private final Integer nextEventWait;
    private final Locale locale;

    protected BaseRequest(String number, Integer length, Locale locale, String country, Integer pinExpiry, Integer nextEventWait) {
        this.number = new E164(number).toString();
        this.locale = locale;
        this.country = country;
        this.length = length;
        if (this.length != null && length != 4 && length != 6) {
            throw new IllegalArgumentException("code_length must be 4 or 6.");
        }
        this.pinExpiry = pinExpiry;
        if (this.pinExpiry != null && (pinExpiry < 60 || pinExpiry > 3600)) {
            throw new IllegalArgumentException("pin_expiry '" + pinExpiry + "' is out of bounds.");
        }
        this.nextEventWait = nextEventWait;
        if (this.nextEventWait != null && (nextEventWait < 60 || nextEventWait > 900)) {
            throw new IllegalArgumentException("next_event_wait '" + nextEventWait + "' is out of bounds.");
        }
    }

    public String getNumber() {
        return this.number;
    }

    public Integer getLength() {
        return this.length;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getDashedLocale() {
        if (this.locale != null) {
            return this.locale.toLanguageTag().toLowerCase();
        }
        return null;
    }

    public String getCountry() {
        return this.country;
    }

    public Integer getPinExpiry() {
        return this.pinExpiry;
    }

    public Integer getNextEventWait() {
        return this.nextEventWait;
    }

    public String toString() {
        return "number='" + this.number + '\'' + ", length=" + this.length + ", locale=" + this.locale + ", country='" + this.country + '\'' + ", pinExpiry=" + this.pinExpiry + ", nextEventWait=" + this.nextEventWait;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.number != null) {
            params.put("number", this.number);
        }
        if (this.length != null && this.length > 0) {
            params.put("code_length", String.valueOf(this.length));
        }
        if (this.locale != null) {
            params.put("lg", this.getDashedLocale());
        }
        if (this.country != null) {
            params.put("country", this.country);
        }
        if (this.pinExpiry != null) {
            params.put("pin_expiry", String.valueOf(this.pinExpiry));
        }
        if (this.nextEventWait != null) {
            params.put("next_event_wait", String.valueOf(this.nextEventWait));
        }
        return params;
    }
}

