/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.annotation.JsonValue;
import com.vonage.client.verify.BaseRequest;
import java.util.Locale;
import java.util.Map;

public class Psd2Request
extends BaseRequest {
    private final Double amount;
    private final String payee;
    private final Workflow workflow;

    private Psd2Request(Builder builder) {
        super(builder.number, builder.length, builder.locale, builder.country, builder.pinExpiry, builder.nextEventWait);
        this.payee = builder.payee;
        if (this.payee == null || this.payee.isEmpty() || this.payee.length() > 18) {
            throw new IllegalArgumentException("Payee is required and cannot exceed 18 characters.");
        }
        this.workflow = builder.workflow;
        this.amount = builder.amount;
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getPayee() {
        return this.payee;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String number, Double amount, String payee) {
        return new Builder(number, amount, payee);
    }

    @Override
    public String toString() {
        return "Psd2Request{" + super.toString() + ", amount=" + this.amount + ", payee='" + this.payee + '\'' + ", workflow=" + (Object)((Object)this.workflow) + '}';
    }

    @Override
    public Map<String, String> makeParams() {
        Map<String, String> params = super.makeParams();
        params.put("payee", this.payee);
        params.put("amount", Double.toString(this.amount));
        if (this.workflow != null) {
            params.put("workflow_id", Integer.toString(this.workflow.id));
        }
        return params;
    }

    public static class Builder {
        private double amount;
        private String payee;
        private String number;
        private String country;
        private Workflow workflow;
        private Locale locale;
        private Integer length;
        private Integer pinExpiry;
        private Integer nextEventWait;

        public Builder(String number, Double amount, String payee) {
            this.number = number;
            this.payee = payee;
            this.amount = amount;
        }

        private Builder() {
        }

        public Builder payee(String payee) {
            this.payee = payee;
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder workflow(Workflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder pinExpiry(Integer pinExpiry) {
            this.pinExpiry = pinExpiry;
            return this;
        }

        public Builder nextEventWait(Integer nextEventWait) {
            this.nextEventWait = nextEventWait;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Psd2Request build() {
            return new Psd2Request(this);
        }
    }

    public static enum Workflow {
        SMS_TTS_TTS(1),
        SMS_SMS_TTS(2),
        TTS_TTS(3),
        SMS_SMS(4),
        SMS_TTS(5),
        SMS(6),
        TTS(7);

        private final int id;

        private Workflow(int id) {
            this.id = id;
        }

        @JsonValue
        public int getId() {
            return this.id;
        }
    }
}

