/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.vonage.client.Jsonable;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.verify.SearchVerifyResponseDeserializer;
import com.vonage.client.verify.VerifyDetails;
import com.vonage.client.verify.VerifyStatus;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchVerifyResponse
implements Jsonable {
    private VerifyStatus status;
    private List<VerifyDetails> verificationRequests;
    private String errorText;

    @JsonCreator
    SearchVerifyResponse() {
        this(null);
    }

    SearchVerifyResponse(List<VerifyDetails> verificationRequests) {
        this.status = VerifyStatus.OK;
        this.verificationRequests = verificationRequests;
    }

    SearchVerifyResponse(VerifyStatus status, String errorText) {
        this.status = status;
        this.errorText = errorText;
    }

    @JsonProperty(value="status")
    public VerifyStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="verification_requests")
    public List<VerifyDetails> getVerificationRequests() {
        return this.verificationRequests;
    }

    @JsonProperty(value="error_text")
    public String getErrorText() {
        return this.errorText;
    }

    @Override
    public void updateFromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            SimpleModule module = new SimpleModule();
            module.addDeserializer(SearchVerifyResponse.class, (JsonDeserializer)new SearchVerifyResponseDeserializer());
            mapper.registerModule((Module)module);
            SearchVerifyResponse parsed = (SearchVerifyResponse)mapper.readValue(json, SearchVerifyResponse.class);
            this.status = parsed.status;
            this.verificationRequests = parsed.verificationRequests;
            this.errorText = parsed.errorText;
        }
        catch (IOException jme) {
            throw new VonageResponseParseException("Failed to produce SearchVerifyResponse from json.", jme);
        }
    }

    public static SearchVerifyResponse fromJson(String json) {
        return (SearchVerifyResponse)Jsonable.fromJson((String)json, (Jsonable[])new SearchVerifyResponse[0]);
    }
}

