/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.verify.CheckRequest;
import com.vonage.client.verify.CheckResponse;
import com.vonage.client.verify.ControlRequest;
import com.vonage.client.verify.ControlResponse;
import com.vonage.client.verify.Psd2Request;
import com.vonage.client.verify.SearchRequest;
import com.vonage.client.verify.SearchVerifyResponse;
import com.vonage.client.verify.VerifyControlCommand;
import com.vonage.client.verify.VerifyException;
import com.vonage.client.verify.VerifyRequest;
import com.vonage.client.verify.VerifyResponse;
import java.util.Locale;

public class VerifyClient {
    final RestEndpoint<CheckRequest, CheckResponse> check;
    final RestEndpoint<VerifyRequest, VerifyResponse> verify;
    final RestEndpoint<SearchRequest, SearchVerifyResponse> search;
    final RestEndpoint<ControlRequest, ControlResponse> control;
    final RestEndpoint<Psd2Request, VerifyResponse> psd2;

    public VerifyClient(final HttpWrapper wrapper) {
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(String path, boolean formEncoded, R ... type) {
                super(DynamicEndpoint.builder(type).wrapper(var5_5).requestMethod(HttpMethod.POST).authMethod(TokenAuthMethod.class, new Class[0]).contentTypeHeader(formEncoded ? "application/x-www-form-urlencoded" : null).pathGetter((de, req) -> de.getHttpWrapper().getHttpConfig().getApiBaseUri() + "/verify" + path + "/json"));
            }
        }
        this.verify = new Endpoint("", true, (Object[])new VerifyResponse[0]);
        this.check = new Endpoint("/check", true, (Object[])new CheckResponse[0]);
        this.search = new Endpoint("/search", false, (Object[])new SearchVerifyResponse[0]);
        this.psd2 = new Endpoint("/psd2", true, (Object[])new VerifyResponse[0]);
        this.control = new Endpoint<ControlRequest, ControlResponse>("/control", true, new ControlResponse[0]){
            {
                super(VerifyClient.this, path, formEncoded, (Object[])type, httpWrapper);
            }

            @Override
            public ControlResponse postProcessParsedResponse(ControlResponse parsed) {
                if (parsed.getStatus().equals("0")) {
                    return parsed;
                }
                throw new VerifyException(parsed.getStatus(), parsed.getErrorText());
            }
        };
    }

    public VerifyResponse verify(String number, String brand) throws VonageResponseParseException, VonageClientException {
        return this.verify(new VerifyRequest.Builder(number, brand).build());
    }

    public VerifyResponse verify(String number, String brand, VerifyRequest.Workflow workflow) throws VonageResponseParseException, VonageClientException {
        return this.verify(new VerifyRequest.Builder(number, brand).workflow(workflow).build());
    }

    public VerifyResponse verify(String number, String brand, String from) throws VonageClientException, VonageResponseParseException {
        return this.verify(new VerifyRequest.Builder(number, brand).senderId(from).build());
    }

    public VerifyResponse verify(String number, String brand, String from, int length, Locale locale) throws VonageClientException, VonageResponseParseException {
        return this.verify(VerifyRequest.builder(number, brand).length(length).senderId(from).locale(locale).build());
    }

    public VerifyResponse verify(VerifyRequest request) throws VonageClientException, VonageResponseParseException {
        return this.verify.execute(request);
    }

    public CheckResponse check(CheckRequest request) throws VonageClientException, VonageResponseParseException {
        return this.check.execute(request);
    }

    public CheckResponse check(String requestId, String code) throws VonageClientException, VonageResponseParseException {
        return this.check(new CheckRequest(requestId, code));
    }

    public SearchVerifyResponse search(String requestId) throws VonageClientException, VonageResponseParseException {
        return this.search.execute(new SearchRequest(requestId));
    }

    public SearchVerifyResponse search(String ... requestIds) throws VonageClientException, VonageResponseParseException {
        return this.search.execute(new SearchRequest(requestIds));
    }

    public ControlResponse advanceVerification(String requestId) throws VonageClientException, VonageResponseParseException {
        return this.control.execute(new ControlRequest(requestId, VerifyControlCommand.TRIGGER_NEXT_EVENT));
    }

    public ControlResponse cancelVerification(String requestId) throws VonageClientException, VonageResponseParseException {
        return this.control.execute(new ControlRequest(requestId, VerifyControlCommand.CANCEL));
    }

    public VerifyResponse psd2Verify(String number, Double amount, String payee) throws VonageClientException, VonageResponseParseException {
        return this.psd2Verify(new Psd2Request.Builder(number, amount, payee).build());
    }

    public VerifyResponse psd2Verify(String number, Double amount, String payee, Psd2Request.Workflow workflow) throws VonageClientException, VonageResponseParseException {
        return this.psd2Verify(new Psd2Request.Builder(number, amount, payee).workflow(workflow).build());
    }

    public VerifyResponse psd2Verify(Psd2Request psd2Request) throws VonageClientException, VonageResponseParseException {
        return this.psd2.execute(psd2Request);
    }
}

