/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.vonage.client.verify.VerifyStatusDeserializer;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@JsonDeserialize(using=VerifyStatusDeserializer.class)
public enum VerifyStatus {
    OK(0),
    THROTTLED(1),
    MISSING_PARAMS(2),
    INVALID_PARAMS(3),
    INVALID_CREDENTIALS(4),
    INTERNAL_ERROR(5),
    INVALID_REQUEST(6),
    NUMBER_BARRED(7),
    PARTNER_ACCOUNT_BARRED(8),
    PARTNER_QUOTA_EXCEEDED(9),
    ALREADY_REQUESTED(10),
    UNSUPPORTED_NETWORK(15),
    INVALID_CODE(16),
    WRONG_CODE_THROTTLED(17),
    WAIT_FOR_COMPLETION(19),
    UNSUPPORTED_PIN_CODE(20),
    NON_PERMITTED_DESTINATION(29),
    UNKNOWN(Integer.MAX_VALUE);

    private final int verifyStatus;
    private static final Map<Integer, VerifyStatus> VERIFY_STATUS_INDEX;

    public static VerifyStatus fromInt(int verifyStatus) {
        return VERIFY_STATUS_INDEX.getOrDefault(verifyStatus, UNKNOWN);
    }

    private VerifyStatus(int verifyStatus) {
        this.verifyStatus = verifyStatus;
    }

    public int getVerifyStatus() {
        return this.verifyStatus;
    }

    static {
        VERIFY_STATUS_INDEX = Arrays.stream(VerifyStatus.values()).collect(Collectors.toMap(VerifyStatus::getVerifyStatus, Function.identity()));
    }
}

