/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.verify2.SilentAuthWorkflow;
import com.vonage.client.verify2.WhatsappCodelessWorkflow;
import com.vonage.client.verify2.Workflow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VerificationRequest
implements Jsonable {
    static final Pattern CODE_REGEX = Pattern.compile("[a-zA-Z0-9]{4,10}");
    @JsonProperty(value="locale")
    protected final Locale locale;
    protected final Integer channelTimeout;
    protected final Integer codeLength;
    protected final Boolean fraudCheck;
    protected final String brand;
    protected final String code;
    protected final String clientRef;
    protected final List<Workflow> workflows;

    VerificationRequest(Builder builder) {
        this.locale = builder.locale;
        this.clientRef = builder.clientRef;
        this.fraudCheck = builder.fraudCheck != null && builder.fraudCheck == false ? Boolean.valueOf(false) : null;
        this.brand = builder.brand;
        if (this.brand == null || this.brand.isEmpty()) {
            throw new IllegalArgumentException("Brand name is required.");
        }
        this.channelTimeout = builder.timeout;
        if (this.channelTimeout != null && (this.channelTimeout < 60 || this.channelTimeout > 900)) {
            throw new IllegalArgumentException("Delivery wait timeout must be between 60 and 900 seconds.");
        }
        this.workflows = builder.workflows;
        if (this.workflows.isEmpty()) {
            throw new IllegalStateException("At least one workflow must be defined.");
        }
        this.codeLength = builder.codeLength;
        if (this.codeLength != null && (this.codeLength < 4 || this.codeLength > 10)) {
            throw new IllegalArgumentException("Code length must be between 4 and 10 (inclusive).");
        }
        this.code = builder.code;
        if (this.code != null && !CODE_REGEX.matcher(this.code).matches()) {
            throw new IllegalArgumentException("Custom verification code must be 4-10 alphanumeric characters.");
        }
        if (this.isCodeless()) {
            if (this.codeLength != null) {
                throw new IllegalStateException("Code length has no effect for codeless workflows.");
            }
            if (this.code != null) {
                throw new IllegalStateException("Code has no effect for codeless workflows.");
            }
        }
        if (this.code != null && this.codeLength != null && this.code.length() != this.codeLength.intValue()) {
            throw new IllegalStateException("Code '" + this.code + "' is not " + this.codeLength + " characters.");
        }
        if (this.workflows.stream().anyMatch(SilentAuthWorkflow.class::isInstance) && !(this.workflows.get(0) instanceof SilentAuthWorkflow)) {
            throw new IllegalStateException("Silent Auth must be the first workflow.");
        }
    }

    @JsonProperty(value="brand")
    public String getBrand() {
        return this.brand;
    }

    @JsonIgnore
    public Locale getLocale() {
        return this.locale;
    }

    @JsonGetter(value="locale")
    protected String getLocaleAsString() {
        return this.locale == null ? null : this.locale.toString().replace("_", "-").toLowerCase();
    }

    @JsonProperty(value="channel_timeout")
    public Integer getChannelTimeout() {
        return this.channelTimeout;
    }

    @JsonProperty(value="code_length")
    public Integer getCodeLength() {
        return this.codeLength;
    }

    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="client_ref")
    public String getClientRef() {
        return this.clientRef;
    }

    @JsonProperty(value="fraud_check")
    public Boolean getFraudCheck() {
        return this.fraudCheck;
    }

    @JsonProperty(value="workflow")
    protected List<Workflow> getWorkflows() {
        return this.workflows;
    }

    @JsonIgnore
    public boolean isCodeless() {
        return this.workflows.stream().allMatch(type -> type instanceof WhatsappCodelessWorkflow || type instanceof SilentAuthWorkflow);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        Boolean fraudCheck;
        String brand;
        String code;
        String clientRef;
        Integer timeout;
        Integer codeLength;
        Locale locale;
        List<Workflow> workflows = new ArrayList<Workflow>(1);

        Builder() {
        }

        public Builder addWorkflow(Workflow workflow) {
            this.workflows.add(Objects.requireNonNull(workflow, "Workflow cannot be null"));
            return this;
        }

        public Builder workflows(List<Workflow> workflows) {
            this.workflows.clear();
            this.workflows.addAll((Collection<Workflow>)Objects.requireNonNull(workflows, "Workflows must not be null."));
            return this;
        }

        public Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder codeLength(int codeLength) {
            this.codeLength = codeLength;
            return this;
        }

        public Builder channelTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder locale(Locale locale) {
            if (locale == null || locale.toString().isEmpty()) {
                throw new IllegalArgumentException("Invalid locale");
            }
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            return this.locale(Locale.forLanguageTag(locale));
        }

        public Builder clientRef(String clientRef) {
            this.clientRef = clientRef;
            return this;
        }

        public Builder fraudCheck(boolean fraudCheck) {
            this.fraudCheck = fraudCheck;
            return this;
        }

        public Builder fraudCheck() {
            return this.fraudCheck(false);
        }

        public VerificationRequest build() {
            return new VerificationRequest(this);
        }
    }
}

