/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.verify2.VerificationRequest;
import com.vonage.client.verify2.VerificationResponse;
import com.vonage.client.verify2.VerifyCodeRequestWrapper;
import com.vonage.client.verify2.VerifyResponseException;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;

public class Verify2Client {
    final boolean hasJwtAuthMethod;
    final RestEndpoint<VerificationRequest, VerificationResponse> verifyUser;
    final RestEndpoint<VerifyCodeRequestWrapper, Void> verifyRequest;
    final RestEndpoint<UUID, Void> cancel;

    public Verify2Client(final HttpWrapper wrapper) {
        this.hasJwtAuthMethod = wrapper.getAuthCollection().hasAuthMethod(JWTAuthMethod.class);
        final class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).responseExceptionType(VerifyResponseException.class).wrapper(var5_5).requestMethod(method).authMethod(JWTAuthMethod.class, TokenAuthMethod.class).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getVersionedApiBaseUri("v2") + "/verify";
                    return pathGetter != null ? base + "/" + (String)pathGetter.apply(req) : base;
                }));
            }
        }
        this.verifyUser = new Endpoint(null, HttpMethod.POST, (Object[])new VerificationResponse[0]);
        this.verifyRequest = new Endpoint(req -> req.requestId, HttpMethod.POST, (Object[])new Void[0]);
        this.cancel = new Endpoint(UUID::toString, HttpMethod.DELETE, (Object[])new Void[0]);
    }

    private UUID validateRequestId(UUID requestId) {
        return Objects.requireNonNull(requestId, "Request ID is required.");
    }

    public VerificationResponse sendVerification(VerificationRequest request) {
        if (request.isCodeless() && !this.hasJwtAuthMethod) {
            throw new IllegalStateException("Codeless verification requires an application ID to be set in order to use webhooks.");
        }
        return this.verifyUser.execute(Objects.requireNonNull(request));
    }

    public void checkVerificationCode(UUID requestId, String code) {
        this.verifyRequest.execute(new VerifyCodeRequestWrapper(this.validateRequestId(requestId).toString(), Objects.requireNonNull(code, "Code is required.")));
    }

    public void cancelVerification(UUID requestId) {
        this.cancel.execute(this.validateRequestId(requestId));
    }
}

