/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.verify2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.verify2.Channel;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Workflow {
    protected Channel channel;
    protected String to;
    protected String from;

    protected Workflow(Channel channel, String to) {
        this(channel, to, null);
    }

    protected Workflow(Channel channel, String to, String from) {
        this.channel = Objects.requireNonNull(channel, "Verification channel is required.");
        this.to = to;
        if (this.to == null || to.trim().isEmpty()) {
            throw new IllegalArgumentException("Recipient is required.");
        }
        this.from = from;
        if (this.from != null && from.trim().isEmpty()) {
            throw new IllegalArgumentException("Sender cannot be empty.");
        }
    }

    @JsonProperty(value="channel")
    public Channel getChannel() {
        return this.channel;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }
}

