/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.vonage.client.QueryParamsRequest;
import java.util.LinkedHashMap;
import java.util.Map;

public class ListStreamCompositionsRequest
implements QueryParamsRequest {
    private final Integer offset;
    private final Integer count;
    private final String sessionId;

    public ListStreamCompositionsRequest(Builder builder) {
        this.sessionId = builder.sessionId;
        this.offset = builder.offset;
        if (this.offset != null && this.offset < 0) {
            throw new IllegalArgumentException("Offset cannot be negative.");
        }
        this.count = builder.count;
        if (this.count != null && (this.count < 0 || this.count > 1000)) {
            throw new IllegalArgumentException("Count must be between 0 and 1000.");
        }
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(4);
        if (this.offset != null) {
            params.put("offset", this.offset.toString());
        }
        if (this.count != null) {
            params.put("count", this.count.toString());
        }
        if (this.sessionId != null) {
            params.put("sessionId", this.sessionId);
        }
        return params;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer offset;
        private Integer count;
        private String sessionId;

        Builder() {
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder count(int count) {
            this.count = count;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ListStreamCompositionsRequest build() {
            return new ListStreamCompositionsRequest(this);
        }
    }
}

