/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import java.util.regex.Pattern;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
class SendDtmfRequest
implements Jsonable {
    static final Pattern DTMF_DIGITS_PATTERN = Pattern.compile("[0-9*#p]+");
    @JsonIgnore
    final String sessionId;
    @JsonIgnore
    final String connectionId;
    @JsonProperty(value="digits")
    final String digits;

    SendDtmfRequest(String sessionId, String connectionId, String digits) {
        this.sessionId = sessionId;
        this.connectionId = connectionId;
        this.digits = digits;
        if (this.digits == null || !DTMF_DIGITS_PATTERN.matcher(digits).matches()) {
            throw new IllegalArgumentException("DTMF digits must match pattern: " + DTMF_DIGITS_PATTERN.pattern());
        }
    }
}

