/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SessionStream
implements Jsonable {
    private UUID id;
    private List<String> layoutClassList;

    protected SessionStream() {
    }

    protected SessionStream(Builder builder) {
        this.id = builder.id;
        this.layoutClassList = builder.layoutClassList;
    }

    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="layoutClassList")
    public List<String> getLayoutClassList() {
        return this.layoutClassList;
    }

    public static Builder builder(String streamId) {
        return new Builder(streamId);
    }

    public static class Builder {
        private final UUID id;
        private List<String> layoutClassList;

        protected Builder(String id) {
            this.id = UUID.fromString(id);
        }

        public Builder layoutClassList(List<String> layoutClassList) {
            this.layoutClassList = layoutClassList;
            return this;
        }

        public Builder layoutClassList(String ... layoutClasses) {
            return this.layoutClassList(Arrays.asList(layoutClasses));
        }

        public SessionStream build() {
            return new SessionStream(this);
        }
    }
}

