/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.video;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.video.Resolution;
import com.vonage.client.video.StreamCompositionLayout;
import com.vonage.client.video.StreamMode;
import com.vonage.client.video.VideoStream;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class StreamComposition
implements Jsonable {
    @JsonProperty(value="id")
    protected UUID id;
    @JsonProperty(value="applicationId")
    protected UUID applicationId;
    @JsonProperty(value="sessionId")
    protected String sessionId;
    @JsonProperty(value="streamMode")
    protected StreamMode streamMode;
    @JsonProperty(value="resolution")
    protected Resolution resolution;
    @JsonProperty(value="layout")
    protected StreamCompositionLayout layout;
    @JsonProperty(value="hasVideo")
    protected Boolean hasVideo;
    @JsonProperty(value="hasAudio")
    protected Boolean hasAudio;
    @JsonProperty(value="createdAt")
    protected Long createdAt;
    @JsonProperty(value="streams")
    protected List<VideoStream> streams;

    protected StreamComposition() {
    }

    protected StreamComposition(Builder builder) {
        this.sessionId = Objects.requireNonNull(builder.sessionId, "Session ID is required");
        this.streamMode = builder.streamMode;
        this.resolution = builder.resolution;
        this.hasAudio = builder.hasAudio;
        this.hasVideo = builder.hasVideo;
        this.layout = builder.layout;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getApplicationId() {
        return this.applicationId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public Boolean hasVideo() {
        return this.hasVideo;
    }

    public Boolean hasAudio() {
        return this.hasAudio;
    }

    public StreamMode getStreamMode() {
        return this.streamMode;
    }

    public List<VideoStream> getStreams() {
        return this.streams;
    }

    protected StreamCompositionLayout getLayout() {
        return this.layout;
    }

    @JsonProperty(value="createdAt")
    public Long getCreatedAtMillis() {
        return this.createdAt;
    }

    @JsonIgnore
    public Instant getCreatedAt() {
        return this.createdAt != null ? Instant.ofEpochMilli(this.createdAt) : null;
    }

    protected static abstract class Builder {
        protected String sessionId;
        protected Boolean hasAudio;
        protected Boolean hasVideo;
        protected Resolution resolution;
        protected StreamMode streamMode;
        protected StreamCompositionLayout layout;

        protected Builder() {
        }
    }
}

