/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.voice.AdvancedMachineDetection;
import com.vonage.client.voice.Endpoint;
import com.vonage.client.voice.MachineDetection;
import com.vonage.client.voice.PhoneEndpoint;
import com.vonage.client.voice.ncco.Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"_links"})
public class Call
implements Jsonable {
    private Endpoint[] to;
    private Endpoint from;
    private HttpMethod answerMethod = HttpMethod.GET;
    private HttpMethod eventMethod;
    private String answerUrl;
    private String eventUrl;
    private MachineDetection machineDetection;
    private AdvancedMachineDetection advancedMachineDetection;
    private Integer lengthTimer;
    private Integer ringingTimer;
    private Boolean fromRandomNumber;
    private Collection<? extends Action> ncco;

    Call(Builder builder) {
        this.to = builder.to;
        if (this.to == null || this.to.length == 0 || this.to[0] == null) {
            throw new IllegalStateException("At least one recipient should be specified.");
        }
        this.lengthTimer = builder.lengthTimer;
        if (this.lengthTimer != null && (this.lengthTimer > 7200 || this.lengthTimer < 1)) {
            throw new IllegalArgumentException("Length timer must be between 1 and 7200.");
        }
        this.ringingTimer = builder.ringingTimer;
        if (this.ringingTimer != null && (this.ringingTimer > 120 || this.ringingTimer < 1)) {
            throw new IllegalArgumentException("Ringing timer must be between 1 and 120.");
        }
        if (builder.answerMethod != null) {
            this.answerMethod = builder.answerMethod;
            switch (this.answerMethod) {
                case GET: 
                case POST: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Answer method must be GET or POST");
                }
            }
        }
        if ((this.eventMethod = builder.eventMethod) != null) {
            switch (this.eventMethod) {
                case GET: 
                case POST: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Event method must be GET or POST");
                }
            }
        }
        this.from = builder.from;
        this.fromRandomNumber = builder.fromRandomNumber;
        if (this.fromRandomNumber != null && this.fromRandomNumber.booleanValue() && this.from != null) {
            throw new IllegalStateException("From number shouldn't be set if using random.");
        }
        this.answerUrl = builder.answerUrl;
        this.eventUrl = builder.eventUrl;
        this.ncco = builder.ncco;
        this.advancedMachineDetection = builder.advancedMachineDetection;
        this.machineDetection = builder.machineDetection;
        if (this.machineDetection != null && this.advancedMachineDetection != null) {
            throw new IllegalStateException("Cannot set both machineDetection and advancedMachineDetection.");
        }
    }

    Call() {
    }

    public Call(String to, String from, String answerUrl) {
        this((Endpoint)new PhoneEndpoint(to), (Endpoint)new PhoneEndpoint(from), answerUrl);
    }

    public Call(Endpoint to, Endpoint from, String answerUrl) {
        this(new Endpoint[]{to}, from, answerUrl);
    }

    public Call(String to, String from, Collection<? extends Action> ncco) {
        this((Endpoint)new PhoneEndpoint(to), (Endpoint)new PhoneEndpoint(from), ncco);
    }

    public Call(Endpoint to, Endpoint from, Collection<? extends Action> ncco) {
        this(new Endpoint[]{to}, from, ncco);
    }

    public Call(Endpoint[] to, Endpoint from, String answerUrl) {
        this(Call.builder().to(to).from(from).answerUrl(answerUrl));
    }

    public Call(Endpoint[] to, Endpoint from, Collection<? extends Action> ncco) {
        this(Call.builder().to(to).from(from).ncco(ncco));
    }

    @JsonProperty(value="to")
    public Endpoint[] getTo() {
        return this.to;
    }

    @JsonProperty(value="from")
    public Endpoint getFrom() {
        return this.from;
    }

    @JsonProperty(value="answer_url")
    public String[] getAnswerUrl() {
        String[] stringArray;
        if (this.answerUrl != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.answerUrl;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @JsonProperty(value="answer_method")
    public String getAnswerMethod() {
        if (this.answerUrl == null || this.answerMethod == null) {
            return null;
        }
        return this.answerMethod.toString();
    }

    @JsonProperty(value="event_url")
    public String[] getEventUrl() {
        if (this.eventUrl == null) {
            return null;
        }
        return new String[]{this.eventUrl};
    }

    @JsonProperty(value="event_method")
    public String getEventMethod() {
        return this.eventMethod != null ? this.eventMethod.toString() : null;
    }

    @JsonProperty(value="machine_detection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="advanced_machine_detection")
    public AdvancedMachineDetection getAdvancedMachineDetection() {
        return this.advancedMachineDetection;
    }

    @JsonProperty(value="length_timer")
    public Integer getLengthTimer() {
        return this.lengthTimer;
    }

    @JsonProperty(value="ringing_timer")
    public Integer getRingingTimer() {
        return this.ringingTimer;
    }

    @JsonProperty(value="random_from_number")
    public Boolean getFromRandomNumber() {
        return this.fromRandomNumber;
    }

    @JsonProperty(value="ncco")
    public Collection<? extends Action> getNcco() {
        return this.ncco;
    }

    public static Call fromJson(String json) {
        return (Call)Jsonable.fromJson((String)json, (Jsonable[])new Call[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Endpoint[] to;
        private Endpoint from;
        private HttpMethod answerMethod;
        private HttpMethod eventMethod;
        private String answerUrl;
        private String eventUrl;
        private MachineDetection machineDetection;
        private AdvancedMachineDetection advancedMachineDetection;
        private Integer lengthTimer;
        private Integer ringingTimer;
        private Boolean fromRandomNumber;
        private Collection<Action> ncco;

        Builder() {
        }

        public Builder to(Endpoint ... endpoints) {
            this.to = endpoints;
            return this;
        }

        public Builder from(String number) {
            return this.from(new PhoneEndpoint(number));
        }

        Builder from(Endpoint from) {
            this.from = from;
            return this;
        }

        public Builder eventMethod(HttpMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public Builder answerMethod(HttpMethod answerMethod) {
            this.answerMethod = answerMethod;
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder answerUrl(String answerUrl) {
            this.answerUrl = answerUrl;
            return this;
        }

        public Builder machineDetection(MachineDetection machineDetection) {
            this.machineDetection = machineDetection;
            return this;
        }

        public Builder advancedMachineDetection(AdvancedMachineDetection advancedMachineDetection) {
            this.advancedMachineDetection = advancedMachineDetection;
            return this;
        }

        public Builder lengthTimer(int lengthTimer) {
            this.lengthTimer = lengthTimer;
            return this;
        }

        public Builder ringingTimer(int ringingTimer) {
            this.ringingTimer = ringingTimer;
            return this;
        }

        public Builder fromRandomNumber(boolean fromRandomNumber) {
            this.fromRandomNumber = fromRandomNumber;
            return this;
        }

        public Builder ncco(Action ... actions) {
            return this.ncco(Arrays.asList(actions));
        }

        public Builder ncco(Collection<? extends Action> nccos) {
            this.ncco = new ArrayList<Action>(nccos);
            return this;
        }

        public Call build() {
            return new Call(this);
        }
    }
}

