/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.voice.TextToSpeechLanguage;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class TalkPayload
implements Jsonable {
    @JsonIgnore
    String uuid;
    private final String text;
    private final Integer loop;
    private final Integer style;
    private final Double level;
    private final Boolean premium;
    private final TextToSpeechLanguage language;

    private TalkPayload(Builder builder) {
        this.text = builder.text;
        if (this.text == null || this.text.trim().isEmpty()) {
            throw new IllegalArgumentException("Text is required.");
        }
        this.loop = builder.loop;
        if (this.loop != null && this.loop < 0) {
            throw new IllegalArgumentException("Loop cannot be negative.");
        }
        this.style = builder.style;
        if (this.style != null && this.style < 0) {
            throw new IllegalArgumentException("Style cannot be negative.");
        }
        this.level = builder.level;
        if (this.level != null && (this.level < -1.0 || this.level > 1.0)) {
            throw new IllegalArgumentException("Volume level must be between -1 and 1 (inclusive).");
        }
        this.premium = builder.premium;
        this.language = builder.language;
    }

    @JsonProperty(value="loop")
    public Integer getLoop() {
        return this.loop;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="language")
    public TextToSpeechLanguage getLanguage() {
        return this.language;
    }

    @JsonProperty(value="style")
    public Integer getStyle() {
        return this.style;
    }

    @JsonProperty(value="level")
    public Double getLevel() {
        return this.level;
    }

    @JsonProperty(value="premium")
    public Boolean getPremium() {
        return this.premium;
    }

    public static Builder builder(String text) {
        return new Builder(text);
    }

    public static final class Builder {
        private final String text;
        private Integer loop;
        private Integer style;
        private Double level;
        private Boolean premium;
        private TextToSpeechLanguage language;

        Builder(String text) {
            this.text = text;
        }

        public Builder loop(int loop) {
            this.loop = loop;
            return this;
        }

        public Builder style(int style) {
            this.style = style;
            return this;
        }

        public Builder level(double level) {
            this.level = level;
            return this;
        }

        public Builder premium(boolean premium) {
            this.premium = premium;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        public TalkPayload build() {
            return new TalkPayload(this);
        }
    }
}

