/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.common.HttpMethod;
import com.vonage.client.voice.Call;
import com.vonage.client.voice.CallEvent;
import com.vonage.client.voice.CallInfo;
import com.vonage.client.voice.CallInfoPage;
import com.vonage.client.voice.CallsFilter;
import com.vonage.client.voice.DtmfPayload;
import com.vonage.client.voice.DtmfResponse;
import com.vonage.client.voice.ModifyCallAction;
import com.vonage.client.voice.ModifyCallPayload;
import com.vonage.client.voice.StreamPayload;
import com.vonage.client.voice.StreamResponse;
import com.vonage.client.voice.TalkPayload;
import com.vonage.client.voice.TalkResponse;
import com.vonage.client.voice.TextToSpeechLanguage;
import com.vonage.client.voice.TransferCallPayload;
import com.vonage.client.voice.VoiceResponseException;
import com.vonage.client.voice.ncco.Ncco;
import com.vonage.jwt.Jwt;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;

public class VoiceClient {
    final RestEndpoint<Call, CallEvent> createCall;
    final RestEndpoint<String, CallInfo> getCall;
    final RestEndpoint<CallsFilter, CallInfoPage> listCalls;
    final RestEndpoint<ModifyCallPayload, Void> modifyCall;
    final RestEndpoint<StreamPayload, StreamResponse> startStream;
    final RestEndpoint<String, StreamResponse> stopStream;
    final RestEndpoint<TalkPayload, TalkResponse> startTalk;
    final RestEndpoint<String, TalkResponse> stopTalk;
    final RestEndpoint<DtmfPayload, DtmfResponse> sendDtmf;
    final RestEndpoint<String, byte[]> downloadRecording;

    public VoiceClient(final HttpWrapper wrapper) {
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                super(DynamicEndpoint.builder(type).authMethod(JWTAuthMethod.class, new Class[0]).responseExceptionType(VoiceResponseException.class).requestMethod(method).wrapper(var5_5).pathGetter((de, req) -> {
                    String base = de.getHttpWrapper().getHttpConfig().getVersionedApiBaseUri("v1");
                    String path = (String)pathGetter.apply(req);
                    if (path.isEmpty()) {
                        return base + "/calls";
                    }
                    if (path.startsWith("http") && method == HttpMethod.GET) {
                        return path;
                    }
                    return base + "/calls/" + (String)pathGetter.apply(req);
                }));
            }
        }
        this.createCall = new Endpoint(req -> "", HttpMethod.POST, (Object[])new CallEvent[0]);
        this.getCall = new Endpoint(Function.identity(), HttpMethod.GET, (Object[])new CallInfo[0]);
        this.listCalls = new Endpoint(req -> "", HttpMethod.GET, (Object[])new CallInfoPage[0]);
        this.modifyCall = new Endpoint(req -> req.uuid, HttpMethod.PUT, (Object[])new Void[0]);
        this.startStream = new Endpoint(req -> req.uuid + "/stream", HttpMethod.PUT, (Object[])new StreamResponse[0]);
        this.stopStream = new Endpoint(uuid -> uuid + "/stream", HttpMethod.DELETE, (Object[])new StreamResponse[0]);
        this.startTalk = new Endpoint(req -> req.uuid + "/talk", HttpMethod.PUT, (Object[])new TalkResponse[0]);
        this.stopTalk = new Endpoint(uuid -> uuid + "/talk", HttpMethod.DELETE, (Object[])new TalkResponse[0]);
        this.sendDtmf = new Endpoint(req -> req.uuid + "/dtmf", HttpMethod.PUT, (Object[])new DtmfResponse[0]);
        this.downloadRecording = new Endpoint(Function.identity(), HttpMethod.GET, (Object[])new byte[0][]);
    }

    private String validateUuid(String uuid) {
        return Objects.requireNonNull(uuid, "UUID is required.");
    }

    private String validateUrl(String url) {
        if (url == null || url.trim().isEmpty()) {
            throw new IllegalArgumentException("URL is required.");
        }
        return URI.create(url).toString();
    }

    public CallEvent createCall(Call callRequest) throws VonageResponseParseException, VonageClientException {
        return this.createCall.execute(callRequest);
    }

    public CallInfoPage listCalls() throws VonageResponseParseException, VonageClientException {
        return this.listCalls(null);
    }

    public CallInfoPage listCalls(CallsFilter filter) throws VonageResponseParseException, VonageClientException {
        return this.listCalls.execute(filter);
    }

    public CallInfo getCallDetails(String uuid) throws VonageResponseParseException, VonageClientException {
        return this.getCall.execute(this.validateUuid(uuid));
    }

    public DtmfResponse sendDtmf(String uuid, String digits) throws VonageResponseParseException, VonageClientException {
        return this.sendDtmf.execute(new DtmfPayload(digits, this.validateUuid(uuid)));
    }

    private void modifyCall(String callId, ModifyCallAction action) throws VoiceResponseException {
        this.modifyCall.execute(new ModifyCallPayload(action, this.validateUuid(callId)));
    }

    public void earmuffCall(String callId) throws VoiceResponseException {
        this.modifyCall(callId, ModifyCallAction.EARMUFF);
    }

    public void unearmuffCall(String callId) throws VoiceResponseException {
        this.modifyCall(callId, ModifyCallAction.UNEARMUFF);
    }

    public void muteCall(String callId) throws VoiceResponseException {
        this.modifyCall(callId, ModifyCallAction.MUTE);
    }

    public void unmuteCall(String callId) throws VoiceResponseException {
        this.modifyCall(callId, ModifyCallAction.UNMUTE);
    }

    public void terminateCall(String callId) throws VoiceResponseException {
        this.modifyCall(callId, ModifyCallAction.HANGUP);
    }

    public void transferCall(String uuid, String nccoUrl) throws VonageResponseParseException, VonageClientException {
        this.modifyCall.execute(new TransferCallPayload(this.validateUrl(nccoUrl), this.validateUuid(uuid)));
    }

    public void transferCall(String uuid, Ncco ncco) throws VonageResponseParseException, VonageClientException {
        this.modifyCall.execute(new TransferCallPayload(ncco, this.validateUuid(uuid)));
    }

    public StreamResponse startStream(String uuid, String streamUrl, int loop) throws VonageResponseParseException, VonageClientException {
        return this.startStream(uuid, streamUrl, loop, 0.0);
    }

    public StreamResponse startStream(String uuid, String streamUrl, int loop, double level) throws VonageResponseParseException, VonageClientException {
        return this.startStream.execute(new StreamPayload(this.validateUrl(streamUrl), loop, level, this.validateUuid(uuid)));
    }

    public StreamResponse startStream(String uuid, String streamUrl) throws VonageResponseParseException, VonageClientException {
        return this.startStream(uuid, streamUrl, 1);
    }

    public StreamResponse stopStream(String uuid) throws VonageResponseParseException, VonageClientException {
        return this.stopStream.execute(this.validateUuid(uuid));
    }

    public TalkResponse startTalk(String uuid, TalkPayload properties) {
        Objects.requireNonNull(properties, (String)"TalkPayload is required").uuid = this.validateUuid(uuid);
        return this.startTalk.execute(properties);
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text) throws VonageResponseParseException, VonageClientException {
        return this.startTalk(uuid, TalkPayload.builder(text).build());
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language) throws VonageResponseParseException, VonageClientException {
        return this.startTalk(uuid, TalkPayload.builder(text).language(language).build());
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text, int loop) throws VonageResponseParseException, VonageClientException {
        return this.startTalk(uuid, TalkPayload.builder(text).loop(loop).build());
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, int style, int loop) throws VonageResponseParseException, VonageClientException {
        return this.startTalk(uuid, TalkPayload.builder(text).loop(loop).language(language).style(style).build());
    }

    @Deprecated
    public TalkResponse startTalk(String uuid, String text, TextToSpeechLanguage language, int style) throws VonageResponseParseException, VonageClientException {
        return this.startTalk(uuid, TalkPayload.builder(text).language(language).style(style).build());
    }

    public TalkResponse stopTalk(String uuid) throws VonageResponseParseException, VonageClientException {
        return this.stopTalk.execute(this.validateUuid(uuid));
    }

    public byte[] downloadRecordingRaw(String recordingUrl) {
        if (this.validateUrl(recordingUrl).contains(".nexmo.com/v1/files")) {
            return this.downloadRecording.execute(recordingUrl);
        }
        throw new IllegalArgumentException("Invalid recording URL");
    }

    public void saveRecording(String recordingUrl, Path destination) throws IOException {
        Path path = Objects.requireNonNull(destination, "Save path is required.");
        byte[] binary = this.downloadRecordingRaw(recordingUrl);
        if (Files.isDirectory(destination, new LinkOption[0])) {
            String fileName = recordingUrl.substring(recordingUrl.lastIndexOf(47) + 1);
            path = path.resolve(fileName);
        }
        Files.write(path, binary, new OpenOption[0]);
    }

    public static boolean verifySignature(String jwt, String secret) {
        return Jwt.verifySignature((String)jwt, (String)secret);
    }
}

