/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.voice.AdvancedMachineDetection;
import com.vonage.client.voice.MachineDetection;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.Endpoint;
import com.vonage.client.voice.ncco.EventMethod;
import com.vonage.client.voice.ncco.EventType;
import java.util.Arrays;
import java.util.Collection;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectAction
implements Action {
    private static final String ACTION = "connect";
    private Collection<Endpoint> endpoint;
    private String from;
    private EventType eventType;
    private Integer limit;
    private Integer timeOut;
    private MachineDetection machineDetection;
    private AdvancedMachineDetection advancedMachineDetection;
    private Collection<String> eventUrl;
    private EventMethod eventMethod;

    ConnectAction() {
    }

    private ConnectAction(Builder builder) {
        this.endpoint = builder.endpoint;
        this.from = builder.from;
        this.eventType = builder.eventType;
        this.timeOut = builder.timeOut;
        this.limit = builder.limit;
        this.machineDetection = builder.machineDetection;
        this.advancedMachineDetection = builder.advancedMachineDetection;
        this.eventUrl = builder.eventUrl;
        this.eventMethod = builder.eventMethod;
    }

    @Override
    @JsonProperty(value="action")
    public String getAction() {
        return ACTION;
    }

    @JsonProperty(value="endpoint")
    public Collection<Endpoint> getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="eventType")
    public EventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="timeout")
    public Integer getTimeOut() {
        return this.timeOut;
    }

    @JsonProperty(value="limit")
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="machineDetection")
    public MachineDetection getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="advancedMachineDetection")
    public AdvancedMachineDetection getAdvancedMachineDetection() {
        return this.advancedMachineDetection;
    }

    @JsonProperty(value="eventUrl")
    public Collection<String> getEventUrl() {
        return this.eventUrl;
    }

    @JsonProperty(value="eventMethod")
    public EventMethod getEventMethod() {
        return this.eventMethod;
    }

    public static Builder builder(Collection<Endpoint> endpoint) {
        return new Builder(endpoint);
    }

    public static Builder builder(Endpoint ... endpoint) {
        return ConnectAction.builder(Arrays.asList(endpoint));
    }

    public static class Builder {
        private Collection<Endpoint> endpoint;
        private String from;
        private EventType eventType;
        private Integer timeOut;
        private Integer limit;
        private MachineDetection machineDetection;
        private AdvancedMachineDetection advancedMachineDetection;
        private Collection<String> eventUrl;
        private EventMethod eventMethod;

        Builder(Collection<Endpoint> endpoint) {
            this.endpoint = endpoint;
        }

        public Builder endpoint(Collection<Endpoint> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder endpoint(Endpoint ... endpoint) {
            return this.endpoint(Arrays.asList(endpoint));
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder eventType(EventType eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder timeOut(Integer timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder machineDetection(MachineDetection machineDetection) {
            this.machineDetection = machineDetection;
            return this;
        }

        public Builder advancedMachineDetection(AdvancedMachineDetection advancedMachineDetection) {
            this.advancedMachineDetection = advancedMachineDetection;
            return this;
        }

        public Builder eventUrl(Collection<String> eventUrl) {
            this.eventUrl = eventUrl;
            return this;
        }

        public Builder eventUrl(String ... eventUrl) {
            return this.eventUrl(Arrays.asList(eventUrl));
        }

        public Builder eventMethod(EventMethod eventMethod) {
            this.eventMethod = eventMethod;
            return this;
        }

        public ConnectAction build() {
            return new ConnectAction(this);
        }
    }
}

