/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.voice.ncco.Endpoint;
import java.net.URI;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebSocketEndpoint
implements Endpoint {
    private static final String TYPE = "websocket";
    private final URI uri;
    private final String contentType;
    private final Map<String, ?> headers;

    private WebSocketEndpoint(Builder builder) {
        this.uri = builder.uri;
        this.contentType = builder.contentType;
        this.headers = builder.headers;
    }

    @JsonProperty(value="uri")
    public URI getUri() {
        return this.uri;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return TYPE;
    }

    @JsonProperty(value="content-type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="headers")
    public Map<String, ?> getHeaders() {
        return this.headers;
    }

    public static Builder builder(String uri, String contentType) {
        return new Builder(uri, contentType);
    }

    public static class Builder {
        private URI uri;
        private String contentType;
        private Map<String, ?> headers;

        Builder(String uri, String contentType) {
            this.uri = URI.create(uri);
            this.contentType = contentType;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            return this.uri(URI.create(uri));
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder headers(Map<String, ?> headers) {
            this.headers = headers;
            return this;
        }

        public WebSocketEndpoint build() {
            return new WebSocketEndpoint(this);
        }
    }
}

