/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.AbstractMethod;
import com.vonage.client.BinaryRequest;
import com.vonage.client.HttpWrapper;
import com.vonage.client.Jsonable;
import com.vonage.client.QueryParamsRequest;
import com.vonage.client.VonageApiResponseException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.common.HttpMethod;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class DynamicEndpoint<T, R>
extends AbstractMethod<T, R> {
    protected Set<Class<? extends AuthMethod>> authMethods;
    protected String contentType;
    protected String accept;
    protected HttpMethod requestMethod;
    protected BiFunction<DynamicEndpoint<T, R>, ? super T, String> pathGetter;
    protected Class<? extends RuntimeException> responseExceptionType;
    protected Class<R> responseType;
    protected T cachedRequestBody;

    protected DynamicEndpoint(Builder<T, R> builder) {
        super(((Builder)builder).wrapper);
        this.authMethods = Objects.requireNonNull(((Builder)builder).authMethods, "At least one auth method must be defined.");
        this.requestMethod = Objects.requireNonNull(((Builder)builder).requestMethod, "HTTP request method is required.");
        this.pathGetter = Objects.requireNonNull(((Builder)builder).pathGetter, "Path function is required.");
        this.responseType = Objects.requireNonNull(((Builder)builder).responseType, "Response type is required.");
        this.responseExceptionType = ((Builder)builder).responseExceptionType;
        this.contentType = ((Builder)builder).contentType;
        this.accept = ((Builder)builder).accept;
        if (this.accept == null && (Jsonable.class.isAssignableFrom(this.responseType) || this.isJsonableArrayResponse())) {
            this.accept = ContentType.APPLICATION_JSON.getMimeType();
        }
    }

    public static <T, R> Builder<T, R> builder(R[] responseType) {
        return DynamicEndpoint.builder(responseType.getClass().getComponentType());
    }

    public static <T, R> Builder<T, R> builder(Class<R> responseType) {
        return new Builder(responseType);
    }

    static RequestBuilder createRequestBuilderFromRequestMethod(HttpMethod requestMethod) {
        switch (requestMethod) {
            case GET: {
                return RequestBuilder.get();
            }
            case POST: {
                return RequestBuilder.post();
            }
            case PATCH: {
                return RequestBuilder.patch();
            }
            case DELETE: {
                return RequestBuilder.delete();
            }
            case PUT: {
                return RequestBuilder.put();
            }
        }
        throw new IllegalStateException("Unknown request method.");
    }

    @Override
    protected final Set<Class<? extends AuthMethod>> getAcceptableAuthMethods() {
        return this.authMethods;
    }

    private boolean isJsonableArrayResponse() {
        return this.responseType.isArray() && Jsonable.class.isAssignableFrom(this.responseType.getComponentType());
    }

    private String getRequestHeader(T requestBody) {
        if (this.contentType != null) {
            return this.contentType;
        }
        if (requestBody instanceof Jsonable) {
            return ContentType.APPLICATION_JSON.getMimeType();
        }
        if (requestBody instanceof BinaryRequest) {
            return ((BinaryRequest)requestBody).getContentType();
        }
        return null;
    }

    private static void applyQueryParams(Map<String, ?> params, RequestBuilder rqb) {
        params.forEach((k, v) -> {
            Consumer<Object> logic = obj -> rqb.addParameter(k, String.valueOf(obj));
            if (v instanceof Object[]) {
                for (Object nested : (Object[])v) {
                    logic.accept(nested);
                }
            } else if (v instanceof Iterable) {
                for (Object nested : (Iterable)v) {
                    logic.accept(nested);
                }
            } else {
                logic.accept(v);
            }
        });
    }

    public static URI buildUri(String base, Map<String, ?> requestParams) {
        RequestBuilder requestBuilder = RequestBuilder.get((String)base);
        DynamicEndpoint.applyQueryParams(requestParams, requestBuilder);
        return requestBuilder.build().getURI();
    }

    @Override
    protected final RequestBuilder makeRequest(T requestBody) {
        if (requestBody instanceof Jsonable && this.responseType.isAssignableFrom(requestBody.getClass())) {
            this.cachedRequestBody = requestBody;
        }
        RequestBuilder rqb = DynamicEndpoint.createRequestBuilderFromRequestMethod(this.requestMethod);
        String header = this.getRequestHeader(requestBody);
        if (header != null) {
            rqb.setHeader("Content-Type", header);
        }
        if (this.accept != null) {
            rqb.setHeader("Accept", this.accept);
        }
        if (requestBody instanceof QueryParamsRequest) {
            DynamicEndpoint.applyQueryParams(((QueryParamsRequest)requestBody).makeParams(), rqb);
        }
        if (requestBody instanceof Jsonable) {
            rqb.setEntity((HttpEntity)new StringEntity(((Jsonable)requestBody).toJson(), ContentType.APPLICATION_JSON));
        } else if (requestBody instanceof BinaryRequest) {
            BinaryRequest bin = (BinaryRequest)requestBody;
            rqb.setEntity((HttpEntity)new ByteArrayEntity(bin.toByteArray(), ContentType.getByMimeType((String)bin.getContentType())));
        } else if (requestBody instanceof byte[]) {
            rqb.setEntity((HttpEntity)new ByteArrayEntity((byte[])requestBody));
        }
        return rqb.setUri(this.pathGetter.apply(this, (DynamicEndpoint)requestBody));
    }

    @Override
    protected final R parseResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            if (statusCode >= 200 && statusCode < 300) {
                R r = this.parseResponseSuccess(response);
                return r;
            }
            if (statusCode >= 300 && statusCode < 400) {
                R r = this.parseResponseRedirect(response);
                return r;
            }
            R r = this.parseResponseFailure(response);
            return r;
        }
        catch (InvocationTargetException ex) {
            Throwable wrapped = ex.getTargetException();
            if (wrapped instanceof RuntimeException) {
                throw (RuntimeException)wrapped;
            }
            throw new VonageUnexpectedException(wrapped);
        }
        catch (ReflectiveOperationException ex) {
            throw new VonageUnexpectedException(ex);
        }
        finally {
            this.cachedRequestBody = null;
        }
    }

    protected R parseResponseFromString(String response) {
        return null;
    }

    private R parseResponseRedirect(HttpResponse response) throws ReflectiveOperationException, IOException {
        String location = response.getFirstHeader("Location").getValue();
        if (URI.class.equals(this.responseType)) {
            return (R)URI.create(location);
        }
        if (String.class.equals(this.responseType)) {
            return (R)location;
        }
        return this.parseResponseSuccess(response);
    }

    private R parseResponseSuccess(HttpResponse response) throws IOException, ReflectiveOperationException {
        if (Void.class.equals(this.responseType)) {
            return null;
        }
        if (byte[].class.equals(this.responseType)) {
            return (R)EntityUtils.toByteArray((HttpEntity)response.getEntity());
        }
        String deser = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.responseType.equals(String.class)) {
            return (R)deser;
        }
        if (this.cachedRequestBody instanceof Jsonable) {
            ((Jsonable)this.cachedRequestBody).updateFromJson(deser);
            return (R)this.cachedRequestBody;
        }
        if (Jsonable.class.isAssignableFrom(this.responseType)) {
            return Jsonable.fromJson(deser, this.responseType);
        }
        if (Collection.class.isAssignableFrom(this.responseType) || this.isJsonableArrayResponse()) {
            return (R)Jsonable.createDefaultObjectMapper().readValue(deser, this.responseType);
        }
        R customParsedResponse = this.parseResponseFromString(deser);
        if (customParsedResponse == null) {
            throw new IllegalStateException("Unhandled return type: " + this.responseType);
        }
        return customParsedResponse;
    }

    private R parseResponseFailure(HttpResponse response) throws IOException, ReflectiveOperationException {
        R customParsedResponse;
        String exMessage = EntityUtils.toString((HttpEntity)response.getEntity());
        if (this.responseExceptionType != null) {
            if (VonageApiResponseException.class.isAssignableFrom(this.responseExceptionType)) {
                VonageApiResponseException varex = (VonageApiResponseException)Jsonable.fromJson(exMessage, this.responseExceptionType);
                if (varex.title == null) {
                    varex.title = response.getStatusLine().getReasonPhrase();
                }
                varex.statusCode = response.getStatusLine().getStatusCode();
                throw varex;
            }
            for (Constructor<?> constructor : this.responseExceptionType.getDeclaredConstructors()) {
                Class<?>[] params = constructor.getParameterTypes();
                if (params.length != 1 || !String.class.equals(params[0])) continue;
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                throw (RuntimeException)constructor.newInstance(exMessage);
            }
        }
        if ((customParsedResponse = this.parseResponseFromString(exMessage)) == null) {
            throw new VonageApiResponseException(exMessage);
        }
        return customParsedResponse;
    }

    public static final class Builder<T, R> {
        private final Class<R> responseType;
        private Set<Class<? extends AuthMethod>> authMethods;
        private HttpWrapper wrapper;
        private String contentType;
        private String accept;
        private HttpMethod requestMethod;
        private BiFunction<DynamicEndpoint<T, R>, ? super T, String> pathGetter;
        private Class<? extends RuntimeException> responseExceptionType;

        Builder(Class<R> responseType) {
            this.responseType = responseType;
        }

        public Builder<T, R> wrapper(HttpWrapper wrapper) {
            this.wrapper = wrapper;
            return this;
        }

        public Builder<T, R> requestMethod(HttpMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        public Builder<T, R> pathGetter(BiFunction<DynamicEndpoint<T, R>, T, String> pathGetter) {
            this.pathGetter = pathGetter;
            return this;
        }

        public Builder<T, R> authMethod(Class<? extends AuthMethod> primary, Class<? extends AuthMethod> ... others) {
            this.authMethods = new LinkedHashSet<Class<? extends AuthMethod>>(2);
            this.authMethods.add(Objects.requireNonNull(primary, "Primary auth method cannot be null."));
            if (others != null) {
                for (Class<? extends AuthMethod> amc : others) {
                    if (amc == null) continue;
                    this.authMethods.add(amc);
                }
            }
            return this;
        }

        public Builder<T, R> responseExceptionType(Class<? extends RuntimeException> responseExceptionType) {
            this.responseExceptionType = responseExceptionType;
            return this;
        }

        public Builder<T, R> urlFormEncodedContentType(boolean formEncoded) {
            return this.contentTypeHeader(formEncoded ? "application/x-www-form-urlencoded" : null);
        }

        public Builder<T, R> contentTypeHeader(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder<T, R> acceptHeader(String accept) {
            this.accept = accept;
            return this;
        }

        public DynamicEndpoint<T, R> build() {
            return new DynamicEndpoint(this);
        }
    }
}

