/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.hashutils.HashUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;

public class RequestSigning {
    public static final int MAX_ALLOWABLE_TIME_DELTA = 300000;
    public static final String PARAM_SIGNATURE = "sig";
    public static final String PARAM_TIMESTAMP = "timestamp";
    public static final String APPLICATION_JSON = "application/json";
    private static final Log log = LogFactory.getLog(RequestSigning.class);

    @Deprecated
    public static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey) {
        RequestSigning.constructSignatureForRequestParameters(params, secretKey, HashUtil.HashType.HMAC_MD5);
    }

    @Deprecated
    public static void constructSignatureForRequestParameters(List<NameValuePair> params, String secretKey, HashUtil.HashType hashType) {
        Map sortedParams = params.stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (v1, v2) -> v1, TreeMap::new));
        RequestSigning.constructSignatureForRequestParameters(sortedParams, secretKey, hashType);
    }

    @Deprecated
    public static void constructSignatureForRequestParameters(Map<String, String> params, String secretKey, HashUtil.HashType hashType) {
        params.putAll(RequestSigning.getSignatureForRequestParameters(params, secretKey, hashType));
    }

    public static Map<String, String> getSignatureForRequestParameters(Map<String, String> params, String secretKey, HashUtil.HashType hashType) {
        return RequestSigning.constructSignatureForRequestParameters(params, secretKey, Instant.now().getEpochSecond(), hashType);
    }

    private static String clean(String str) {
        return str == null ? null : str.replaceAll("[=&]", "_");
    }

    static String generateParamsString(Map<String, String> params) {
        SortedMap<Object, Object> sortedParams = params instanceof SortedMap ? (SortedMap<Object, Object>)params : new TreeMap<String, String>(params);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry param : sortedParams.entrySet()) {
            String name = (String)param.getKey();
            String value = (String)param.getValue();
            if (PARAM_SIGNATURE.equals(name) || value == null || value.trim().isEmpty()) continue;
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        return sb.toString();
    }

    static Map<String, String> constructSignatureForRequestParameters(Map<String, String> inputParams, String secretKey, long currentTimeSeconds, HashUtil.HashType hashType) {
        String hashed;
        String timestampStr = Long.toString(currentTimeSeconds);
        TreeMap<String, String> tempParams = new TreeMap<String, String>(inputParams);
        tempParams.put(PARAM_TIMESTAMP, timestampStr);
        String str = RequestSigning.generateParamsString(tempParams);
        try {
            hashed = HashUtil.calculate(str, secretKey, "UTF-8", hashType);
        }
        catch (Exception ex) {
            log.error((Object)"error...", (Throwable)ex);
            hashed = "no signature";
        }
        log.debug((Object)("SECURITY-KEY-GENERATION -- String [ " + str + " ] Signature [ " + hashed + " ] "));
        LinkedHashMap<String, String> outputParams = new LinkedHashMap<String, String>(4);
        outputParams.put(PARAM_TIMESTAMP, timestampStr);
        outputParams.put(PARAM_SIGNATURE, hashed);
        return outputParams;
    }

    public static boolean verifyRequestSignature(InputStream inputStream, String contentType, Map<String, String[]> parameterMap, String secretKey) {
        return RequestSigning.verifyRequestSignature(contentType, inputStream, parameterMap, secretKey, System.currentTimeMillis());
    }

    protected static boolean verifyRequestSignature(String contentType, InputStream inputStream, Map<String, String[]> parameterMap, String secretKey, long currentTimeMillis) {
        return RequestSigning.verifyRequestSignature(contentType, inputStream, parameterMap, secretKey, currentTimeMillis, HashUtil.HashType.MD5);
    }

    static boolean verifyRequestSignature(String contentType, InputStream inputStream, Map<String, String[]> parameterMap, String secretKey, long currentTimeMillis, HashUtil.HashType hashType) {
        String hashed;
        String suppliedSignature;
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        if (APPLICATION_JSON.equals(contentType) && inputStream != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                Map map = (Map)mapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, String>>(){});
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    log.info((Object)(name + " = " + value));
                    if (value == null || value.trim().isEmpty()) continue;
                    sortedParams.put(name, value);
                }
            }
            catch (IOException iOException) {
                throw new VonageUnexpectedException("Unexpected issue when parsing JSON", iOException);
            }
        } else {
            for (Map.Entry entry : parameterMap.entrySet()) {
                String name = (String)entry.getKey();
                String value = ((String[])entry.getValue())[0];
                log.info((Object)(name + " = " + value));
                if (value == null || value.trim().isEmpty()) continue;
                sortedParams.put(name, value);
            }
        }
        if ((suppliedSignature = (String)sortedParams.get(PARAM_SIGNATURE)) == null) {
            return false;
        }
        String string = (String)sortedParams.get(PARAM_TIMESTAMP);
        long time = -1L;
        try {
            if (string != null) {
                time = Long.parseLong(string) * 1000L;
            }
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error parsing 'time' parameter [ " + string + " ]"), (Throwable)e);
            time = 0L;
        }
        long diff = currentTimeMillis - time;
        if (diff > 300000L || diff < -300000L) {
            log.warn((Object)("SECURITY-KEY-VERIFICATION -- BAD-TIMESTAMP ... Timestamp [ " + time + " ] delta [ " + diff + " ] max allowed delta [ " + -300000 + " ] "));
            return false;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry param : sortedParams.entrySet()) {
            if (((String)param.getKey()).equals(PARAM_SIGNATURE)) continue;
            String name = (String)param.getKey();
            String value = (String)param.getValue();
            sb.append("&").append(RequestSigning.clean(name)).append("=").append(RequestSigning.clean(value));
        }
        String str = sb.toString();
        try {
            hashed = HashUtil.calculate(str, secretKey, "UTF-8", hashType);
        }
        catch (Exception e) {
            log.error((Object)"error...", (Throwable)e);
            return false;
        }
        log.info((Object)("SECURITY-KEY-VERIFICATION -- String [ " + str + " ] Signature [ " + hashed + " ] SUPPLIED SIGNATURE [ " + suppliedSignature + " ] "));
        return MessageDigest.isEqual(hashed.toLowerCase().getBytes(StandardCharsets.UTF_8), suppliedSignature.toLowerCase().getBytes(StandardCharsets.UTF_8));
    }
}

