/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.common;

import com.vonage.client.QueryParamsRequest;
import com.vonage.client.common.SortOrder;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HalFilterRequest
implements QueryParamsRequest {
    protected final String cursor;
    protected final Integer page;
    protected final Integer pageSize;
    protected final SortOrder order;
    protected final Instant startDate;
    protected final Instant endDate;

    protected HalFilterRequest(Builder<?, ?> builder) {
        this.cursor = builder.cursor;
        this.page = this.validatePage(builder.page);
        this.pageSize = this.validatePageSize(builder.pageSize);
        this.order = builder.order;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
    }

    protected Integer validatePage(Integer page) {
        if (page != null && page < 1) {
            throw new IllegalArgumentException("Page must be positive.");
        }
        return page;
    }

    protected Integer validatePageSize(Integer pageSize) {
        if (pageSize != null && (pageSize < 1 || pageSize > 1000)) {
            throw new IllegalArgumentException("Page size must be between 1 and 1000.");
        }
        return pageSize;
    }

    protected HalFilterRequest(Integer page, Integer pageSize, SortOrder order) {
        this.page = this.validatePage(page);
        this.pageSize = this.validatePageSize(pageSize);
        this.order = order;
        this.cursor = null;
        this.startDate = null;
        this.endDate = null;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (this.cursor != null) {
            params.put("cursor", this.cursor);
        }
        if (this.page != null) {
            params.put("page", this.page.toString());
        }
        if (this.pageSize != null) {
            params.put("page_size", this.pageSize.toString());
        }
        if (this.order != null) {
            params.put("order", this.order.toString());
        }
        return params;
    }

    protected Integer getPage() {
        return this.page;
    }

    protected Integer getPageSize() {
        return this.pageSize;
    }

    protected SortOrder getOrder() {
        return this.order;
    }

    protected Instant getStartDate() {
        return this.startDate;
    }

    protected Instant getEndDate() {
        return this.endDate;
    }

    protected String getCursor() {
        return this.cursor;
    }

    protected static abstract class Builder<F extends HalFilterRequest, B extends Builder<? extends F, ? extends B>> {
        protected String cursor;
        protected Integer page;
        protected Integer pageSize;
        protected SortOrder order;
        protected Instant startDate;
        protected Instant endDate;

        protected Builder() {
        }

        protected B cursor(String cursor) {
            this.cursor = cursor;
            return (B)this;
        }

        protected B page(int page) {
            this.page = page;
            return (B)this;
        }

        protected B pageSize(int pageSize) {
            this.pageSize = pageSize;
            return (B)this;
        }

        protected B order(SortOrder order) {
            this.order = order;
            return (B)this;
        }

        protected B startDate(Instant startDate) {
            this.startDate = startDate;
            return (B)this;
        }

        protected B endDate(Instant endDate) {
            this.endDate = endDate;
            return (B)this;
        }

        public abstract F build();
    }
}

